/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.annos.Beta;

@Beta
public class DevelopEnvFileContainer {
    private static Map<String, InputStream> listFiles(String path) throws IOException {
        File file = new File("../src/generated/resources/" + path);
        if (file.exists() && file.isDirectory()) {
            ArrayList<File> needToScan = new ArrayList<File>(List.of(file.listFiles()));
            HashMap<String, InputStream> streamMap = new HashMap<String, InputStream>();
            while (!needToScan.isEmpty()) {
                File f = needToScan.get(0);
                if (!f.exists() || !file.canRead()) continue;
                needToScan.remove(f);
                if (f.isDirectory()) {
                    File[] files = f.listFiles();
                    if (files == null) continue;
                    needToScan.addAll(List.of(files));
                    continue;
                }
                FileInputStream fis = new FileInputStream(f);
                ByteArrayInputStream bis = new ByteArrayInputStream(fis.readAllBytes());
                fis.close();
                streamMap.put(f.getName(), bis);
            }
            return streamMap;
        }
        if (file.exists() && file.isFile()) {
            HashMap<String, InputStream> streamMap = new HashMap<String, InputStream>();
            FileInputStream fis = new FileInputStream(file);
            ByteArrayInputStream bis = new ByteArrayInputStream(fis.readAllBytes());
            fis.close();
            streamMap.put(file.getName(), bis);
            return streamMap;
        }
        file.mkdir();
        return new HashMap<String, InputStream>();
    }
}

