/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.util;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@Util
public class Resources {
    @Util
    public static Map<String, Resource> getResources(ResourceLocation location, boolean isFile) throws IOException {
        ResourceManager rm = Minecraft.m_91087_().m_91098_();
        return Resources.innerGetResources(rm, location, isFile, false);
    }

    @Util
    public static Map<String, Resource> getFullPathResources(ResourceLocation location, boolean isFile) throws IOException {
        ResourceManager rm = Minecraft.m_91087_().m_91098_();
        return Resources.innerGetResources(rm, location, isFile, true);
    }

    @Util
    public static Resource getResource(ResourceLocation location) throws IOException {
        ResourceManager rm = Minecraft.m_91087_().m_91098_();
        return rm.m_142591_(location);
    }

    @Util
    public static Block getBlock(ResourceLocation location) {
        return (Block)ForgeRegistries.BLOCKS.getValue(location);
    }

    @Util
    public static Item getItem(ResourceLocation location) {
        return (Item)ForgeRegistries.ITEMS.getValue(location);
    }

    @Inner
    public static Map<String, Resource> innerGetResources(ResourceManager rm, ResourceLocation location, boolean isFile, boolean fullyPath) throws IOException {
        if (isFile) {
            return Map.of(location.m_135815_(), rm.m_142591_(location));
        }
        Collection resources = rm.m_6540_(location.m_135815_(), l -> true);
        HashMap<String, Resource> result = new HashMap<String, Resource>();
        for (ResourceLocation location1 : resources) {
            if (!location.m_135815_().contains(".") || !location.m_135827_().equals(location.m_135827_()) || !fullyPath) continue;
            if (location1.m_135815_().contains(".")) {
                result.put(location1.m_135815_(), Resources.getResource(location1));
                continue;
            }
            if (!location1.m_135815_().contains(".")) continue;
            result.put(location1.m_135815_().replaceAll(location.m_135815_() + "/", ""), Resources.getResource(location1));
        }
        return result;
    }

    public static JsonReader openAsJson(Resource resource) {
        return new JsonReader((Reader)new InputStreamReader(resource.m_6679_()));
    }

    @Util
    public static class CheatResourceLocation
    extends ResourceLocation {
        private boolean isOutside = true;

        protected CheatResourceLocation(String[] pDecomposedLocation) {
            super(pDecomposedLocation);
        }

        public CheatResourceLocation(String pLocation) {
            super(pLocation);
        }

        public CheatResourceLocation(String pNamespace, String pPath) {
            super(pNamespace, pPath);
        }

        public CheatResourceLocation(String namespace, String path, boolean isOutside) {
            super(namespace, path);
            this.isOutside = isOutside;
        }

        public static CheatResourceLocation copy(ResourceLocation location) {
            if (location instanceof CheatResourceLocation) {
                CheatResourceLocation cheatResourceLocation = (CheatResourceLocation)location;
                return cheatResourceLocation.clone();
            }
            return new CheatResourceLocation(location.m_135827_(), location.m_135815_(), true);
        }

        public CheatResourceLocation clone() {
            return new CheatResourceLocation(this.f_135804_, this.f_135805_, this.isOutside);
        }

        public void setOutside(boolean outside) {
            this.isOutside = outside;
        }

        public boolean isOutside() {
            return this.isOutside;
        }
    }
}

