/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.xml;

import java.util.Optional;
import java.util.Set;
import kasuga.lib.core.xml.IXmlObject;

public class XmlString
implements IXmlObject<String> {
    private String key = "";
    private String value = "";
    private final Set<IXmlObject<?>> attributes;
    private boolean singleSide;

    public XmlString(String key, String value, IXmlObject<?> ... attributes) {
        this.key = key;
        this.value = value;
        this.attributes = Set.of(attributes);
    }

    public XmlString(String key, String value, boolean singleSide, IXmlObject<?> ... attributes) {
        this.key = key;
        this.value = value;
        this.attributes = Set.of(attributes);
        this.singleSide = singleSide;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Set<String> getValues() {
        return Set.of(this.value);
    }

    @Override
    public String getValue(String key) {
        return this.key.equals(key) ? this.value : "";
    }

    @Override
    public void setValue(String key, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        if (this.key.equals(key)) {
            this.value = (String)value;
        }
    }

    @Override
    public Set<IXmlObject<?>> attributes() {
        return this.attributes;
    }

    @Override
    public IXmlObject<?> getAttribute(String key) {
        Optional<IXmlObject> optional = this.attributes.stream().filter(a -> a.key().equals(key)).findAny();
        return optional.orElse(null);
    }

    @Override
    public void setAttribute(String key, Object value) {
        IXmlObject<?> attr = this.getAttribute(key);
        if (attr != null) {
            attr.setValue(key, value);
        }
    }

    private boolean keyIsXml() {
        return this.key.equals("xml");
    }

    @Override
    public String toFormattedString(int stage, boolean isPlainText) {
        String repeat = "    ".repeat(isPlainText ? 0 : Math.max(0, stage));
        StringBuilder builder = new StringBuilder(repeat + (this.keyIsXml() ? "<?" : "<") + this.key);
        for (IXmlObject<?> attr : this.attributes) {
            builder.append(" ").append(attr.key()).append("=");
            if (attr instanceof XmlString) {
                builder.append("\"").append(attr.getValue(attr.key()).toString()).append("\"");
                continue;
            }
            builder.append(attr.getValue(attr.key()).toString());
        }
        builder.append(this.keyIsXml() ? "?>\n" : (this.singleSide ? "/>\n" : ">"));
        if (!this.keyIsXml() && !this.singleSide) {
            builder.append(this.value).append("</").append(this.key).append(">\n");
        }
        return builder.toString();
    }

    @Override
    public boolean isSingleSideElement() {
        return this.singleSide;
    }

    @Override
    public void setIsSingleSide(boolean singleSide) {
        this.singleSide = singleSide;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.toFormattedString(0, false);
    }
}

