/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.function.Function;
import kasuga.lib.core.base.commands.ArgumentTypes.BaseArgument;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceLocation;

public class ArgumentTypeReg
extends Reg {
    public static final HashMap<String, Pair<Class, BaseArgument>> types = new HashMap();
    public static final ArgumentTypeReg INSTANCE = new ArgumentTypeReg("argument_types");

    private ArgumentTypeReg(String registrationKey) {
        super(registrationKey);
    }

    public ArgumentTypeReg registerType(Class target, Function<String, Object> parser) {
        types.put(target.getName(), Pair.of(target, new BaseArgument(parser)));
        return this;
    }

    public <T> T parse(String value, Class<T> target) {
        if (!types.containsKey(target.getName())) {
            throw new NullPointerException("No such parser");
        }
        return (T)ArgumentTypeReg.types.get((Object)target.getName()).getSecond().parser.apply(value);
    }

    @Override
    public ArgumentTypeReg submit(SimpleRegistry registry) {
        return this;
    }

    @Override
    public String getIdentifier() {
        return "argument_types";
    }

    static {
        INSTANCE.registerType(Byte.TYPE, Byte::parseByte);
        INSTANCE.registerType(Short.TYPE, Short::parseShort);
        INSTANCE.registerType(Integer.TYPE, Integer::parseInt);
        INSTANCE.registerType(Character.TYPE, s -> Character.valueOf(s.charAt(0)));
        INSTANCE.registerType(Float.TYPE, Float::parseFloat);
        INSTANCE.registerType(Double.TYPE, Double::parseDouble);
        INSTANCE.registerType(Long.TYPE, Long::parseLong);
        INSTANCE.registerType(String.class, s -> s);
        INSTANCE.registerType(ResourceLocation.class, ResourceLocation::new);
        INSTANCE.registerType(URL.class, s -> {
            try {
                return new URL((String)s);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

