/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.core.network.C2SPacket;
import kasuga.lib.core.network.Packet;
import kasuga.lib.core.network.S2CPacket;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class ChannelReg
extends Reg {
    private SimpleChannel channel = null;
    private String brand = this.registrationKey;
    private int id = 0;
    private final HashSet<PacketBuilder<? extends Packet>> packetBuilders;
    Predicate<String> clientVersions = input -> true;
    Predicate<String> serverVersions = input -> true;

    public ChannelReg(String registrationKey) {
        super(registrationKey);
        this.packetBuilders = new HashSet();
    }

    @Mandatory
    public ChannelReg brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Optional
    public ChannelReg clientVersions(@Nonnull Predicate<String> clientVersions) {
        this.clientVersions = Objects.requireNonNull(clientVersions);
        return this;
    }

    @Optional
    public ChannelReg serverVersions(@Nonnull Predicate<String> serverVersions) {
        this.serverVersions = Objects.requireNonNull(serverVersions);
        return this;
    }

    @Optional
    public ChannelReg loadPacket(Class<?> packetClass, Function<FriendlyByteBuf, ?> decoder) {
        boolean flag0 = C2SPacket.class.isAssignableFrom(packetClass);
        boolean flag1 = S2CPacket.class.isAssignableFrom(packetClass);
        if (!flag0 && !flag1) {
            return this;
        }
        this.loadPacket(Pair.of(packetClass, decoder));
        return this;
    }

    @Override
    @Mandatory
    public ChannelReg submit(SimpleRegistry registry) {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(registry.namespace, this.registrationKey), () -> this.brand, this.clientVersions, this.serverVersions);
        if (!this.packetBuilders.isEmpty()) {
            for (PacketBuilder<? extends Packet> builder : this.packetBuilders) {
                builder.build();
            }
            this.packetBuilders.clear();
        }
        return this;
    }

    public SimpleChannel getChannel() {
        return this.channel;
    }

    public void sendToServer(C2SPacket msg) {
        if (this.channel == null) {
            return;
        }
        this.channel.sendToServer((Object)msg);
    }

    public void sendTo(Packet msg, Connection connection, NetworkDirection direction) {
        if (this.channel == null) {
            return;
        }
        this.channel.sendTo((Object)msg, connection, direction);
    }

    public void sendToClient(S2CPacket msg, Connection connection) {
        this.channel.sendTo((Object)msg, connection, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToClient(S2CPacket msg, ServerPlayer player) {
        this.sendToClient(msg, player.f_8906_.m_6198_());
    }

    public void boardcastToClients(S2CPacket msg, ServerLevel level, BlockPos pos) {
        level.m_7726_().f_8325_.m_183262_(level.m_46865_(pos).m_7697_(), false).forEach(player -> this.sendToClient(msg, (ServerPlayer)player));
    }

    @Override
    public String getIdentifier() {
        return "channel";
    }

    @Inner
    private <T extends Packet> ChannelReg loadPacket(Pair<Class<?>, Function<FriendlyByteBuf, ?>> pair) {
        if (this.channel == null) {
            this.packetBuilders.add(() -> this.loadPacket(pair));
        } else {
            this.channel.messageBuilder(pair.getFirst(), this.id++).encoder(Packet::encode).decoder(pair.getSecond()).consumer((first, second) -> first.onReach((NetworkEvent.Context)second.get())).add();
        }
        return this;
    }

    static interface PacketBuilder<T extends C2SPacket> {
        public void build();
    }
}

