/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.create;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.create.TrackType;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.create.TrackReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class TrackMaterialReg
extends Reg {
    private TrackType trackType = null;
    private ResourceLocation trackParticle = null;
    private Supplier<PartialModel> tieModel;
    private Supplier<PartialModel> leftSegModel;
    private Supplier<PartialModel> rightSegModel;
    private NonNullSupplier<NonNullSupplier<? extends TrackBlock>> blockSupplier = null;
    private ItemLike[] sleepers = null;
    private ItemLike[] rails = null;
    private String langKey = "";
    private boolean replaceable = false;
    private TrackOffsetIdentifier rightOffset = segment -> segment.m_82490_((double)0.965f);
    private TrackMaterial material = null;
    private boolean isCustomRendered = false;

    public TrackMaterialReg(String registrationKey) {
        super(registrationKey);
    }

    public TrackMaterialReg type(TrackType trackType) {
        this.trackType = trackType;
        return this;
    }

    public TrackMaterialReg type(ResourceLocation trackId, TrackMaterial.TrackType.TrackBlockFactory factory) {
        this.trackType = TrackType.of(trackId, factory);
        return this;
    }

    public TrackMaterialReg trackParticle(ResourceLocation particle) {
        this.trackParticle = particle;
        return this;
    }

    public TrackMaterialReg block(NonNullSupplier<NonNullSupplier<? extends TrackBlock>> block) {
        this.blockSupplier = block;
        return this;
    }

    public TrackMaterialReg block(Supplier<TrackReg<?>> reg) {
        this.blockSupplier = () -> ((TrackReg)reg.get()).getEntry();
        return this;
    }

    public TrackMaterialReg sleeper(ItemLike ... items) {
        this.sleepers = items;
        return this;
    }

    public TrackMaterialReg rails(ItemLike ... rali) {
        this.rails = rali;
        return this;
    }

    public TrackMaterialReg isReplaceable(boolean replaceable) {
        this.replaceable = replaceable;
        return this;
    }

    public TrackMaterialReg customModel(Supplier<PartialModel> tie, Supplier<PartialModel> leftSegment, Supplier<PartialModel> rightSegment) {
        this.tieModel = tie;
        this.leftSegModel = leftSegment;
        this.rightSegModel = rightSegment;
        this.isCustomRendered = true;
        return this;
    }

    public TrackMaterialReg defaultModel() {
        this.isCustomRendered = false;
        return this;
    }

    public TrackMaterialReg simpleTrackModelOffset(float halfDistance) {
        this.rightOffset = segment -> segment.m_82490_((double)halfDistance);
        return this;
    }

    public TrackMaterialReg defaultTrackModelOffset() {
        this.rightOffset = segment -> segment.m_82490_((double)0.965f);
        return this;
    }

    public TrackMaterialReg customTrackModelOffset(TrackOffsetIdentifier left, TrackOffsetIdentifier right) {
        this.rightOffset = right;
        return this;
    }

    public TrackMaterialReg lang(String langKey) {
        this.langKey = langKey;
        return this;
    }

    @Override
    public TrackMaterialReg submit(SimpleRegistry registry) {
        TrackMaterialFactory factory = TrackMaterialFactory.make((ResourceLocation)registry.asResource(this.registrationKey)).lang(this.langKey).block(this.blockSupplier).trackType((TrackMaterial.TrackType)this.trackType);
        if (this.trackParticle != null) {
            factory.particle(this.trackParticle);
        }
        if (this.sleepers != null) {
            factory.sleeper(this.sleepers);
        }
        if (this.rails != null) {
            factory.rails(this.rails);
        }
        if (this.isCustomRendered) {
            factory.customModels(() -> this.tieModel, () -> this.leftSegModel, () -> this.rightSegModel);
        } else {
            factory.defaultModels();
        }
        this.material = factory.build();
        KasugaLib.STACKS.cacheTrackMaterialIn(this);
        return this;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public TrackMaterial getMaterial() {
        return this.material;
    }

    public ResourceLocation getTrackParticle() {
        return this.trackParticle;
    }

    public TrackOffsetIdentifier trackOffsets() {
        return this.rightOffset;
    }

    @Override
    public String getIdentifier() {
        return "track_material";
    }

    @FunctionalInterface
    public static interface TrackOffsetIdentifier {
        public Vec3 apply(Vec3 var1);
    }
}

