/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.RootCallTarget;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.ConstructorBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.ConstructorBuiltinsFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.ProxyFunctionBuiltinsFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.CreateObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertySetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSFrameUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunction;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSProxyObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Null;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public final class ProxyFunctionBuiltins
extends JSBuiltinsContainer.Lambda {
    public static final JSBuiltinsContainer BUILTINS = new ProxyFunctionBuiltins();

    protected ProxyFunctionBuiltins() {
        super(JSProxy.CLASS_NAME);
        this.defineFunction(Strings.REVOCABLE, 2, (context, builtin) -> ProxyFunctionBuiltinsFactory.RevocableNodeGen.create(context, builtin, ProxyFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context)));
    }

    public static abstract class RevocableNode
    extends JSBuiltinNode {
        @Node.Child
        private ConstructorBuiltins.ConstructJSProxyNode proxyCreateNode;
        @Node.Child
        private PropertySetNode setRevocableProxySlotNode;
        @Node.Child
        private CreateObjectNode createObjectNode;
        @Node.Child
        private CreateDataPropertyNode createProxyPropertyNode;
        @Node.Child
        private CreateDataPropertyNode createRevokePropertyNode;

        public RevocableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.proxyCreateNode = ConstructorBuiltinsFactory.ConstructJSProxyNodeGen.create(context, builtin, false, null);
            this.setRevocableProxySlotNode = PropertySetNode.createSetHidden(JSProxy.REVOCABLE_PROXY, context);
            this.createObjectNode = CreateObjectNode.create(context);
            this.createProxyPropertyNode = CreateDataPropertyNode.create(context, Strings.PROXY);
            this.createRevokePropertyNode = CreateDataPropertyNode.create(context, Strings.REVOKE);
        }

        @Specialization
        protected Object doDefault(VirtualFrame frame, Object target, Object handler) {
            JSDynamicObject proxy = this.proxyCreateNode.execute(Undefined.instance, target, handler);
            JSFunctionData revokerFunctionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ProxyRevokerFunction, c -> RevocableNode.createProxyRevokerFunctionImpl(c));
            JSFunctionObject revoker = JSFunction.create(this.getRealm(), revokerFunctionData);
            this.setRevocableProxySlotNode.setValue(revoker, proxy);
            JSDynamicObject result = this.createObjectNode.execute(frame);
            this.createProxyPropertyNode.executeVoid(result, proxy);
            this.createRevokePropertyNode.executeVoid(result, revoker);
            return result;
        }

        private static JSFunctionData createProxyRevokerFunctionImpl(final JSContext context) {
            RootCallTarget callTarget = new JavaScriptRootNode(){
                @Node.Child
                private PropertyGetNode getRevocableProxyNode;
                @Node.Child
                private PropertySetNode setRevocableProxyNode;
                @Node.Child
                private IsCallableNode isCallableNode;
                @Node.Child
                private IsConstructorNode isConstructorNode;
                {
                    this.getRevocableProxyNode = PropertyGetNode.createGetHidden(JSProxy.REVOCABLE_PROXY, context);
                    this.setRevocableProxyNode = PropertySetNode.createSetHidden(JSProxy.REVOCABLE_PROXY, context);
                    this.isCallableNode = IsCallableNode.create();
                    this.isConstructorNode = IsConstructorNode.create();
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                    Object revocableProxy = this.getRevocableProxyNode.getValue(functionObject);
                    if (revocableProxy == Null.instance) {
                        return Undefined.instance;
                    }
                    this.setRevocableProxyNode.setValue(functionObject, Null.instance);
                    boolean callable = this.isCallableNode.executeBoolean(revocableProxy);
                    boolean constructor = this.isConstructorNode.executeBoolean(revocableProxy);
                    ((JSProxyObject)revocableProxy).revoke(callable, constructor);
                    return Undefined.instance;
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, callTarget, 0, Strings.EMPTY_STRING);
        }
    }
}

