/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs;

import java.nio.file.LinkOption;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleFile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.GlobalBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;

public abstract class CommonJSFilenameGetterBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSFilenameGetterBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected Object getFileName() {
        return this.getCurrentFileName();
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleString getCurrentFileName() {
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        if (filePath != null) {
            TruffleFile truffleFile = this.getRealm().getEnv().getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]));
            return Strings.fromJavaString(truffleFile.normalize().toString());
        }
        return Strings.UNKNOWN;
    }
}

