/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs;

import java.nio.file.LinkOption;
import java.util.Map;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleFile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.GlobalBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class CommonJSGlobalModuleGetterBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSGlobalModuleGetterBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected Object getObject() {
        return CommonJSGlobalModuleGetterBuiltin.getOrCreateModuleObject(this.getContext(), this.getRealm());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject getOrCreateModuleObject(JSContext context, JSRealm realm) {
        String filePath = CommonJSResolution.getCurrentFileNameFromStack();
        if (filePath != null) {
            TruffleFile truffleFile = realm.getEnv().getPublicTruffleFile(filePath);
            assert (truffleFile.isRegularFile(new LinkOption[0]));
            Map<TruffleFile, JSDynamicObject> requireCache = realm.getCommonJSRequireCache();
            JSDynamicObject cached = requireCache.get(truffleFile);
            if (cached != null) {
                return cached;
            }
            JSObject moduleObject = CommonJSGlobalModuleGetterBuiltin.createModuleObject(context, realm);
            requireCache.put(truffleFile, moduleObject);
            return moduleObject;
        }
        return CommonJSGlobalModuleGetterBuiltin.createModuleObject(context, realm);
    }

    private static JSObject createModuleObject(JSContext context, JSRealm realm) {
        JSObject moduleObject = JSOrdinary.create(context, realm);
        JSObject exportsObject = JSOrdinary.create(context, realm);
        JSObject.set((JSDynamicObject)moduleObject, Strings.EXPORTS_PROPERTY_NAME, (Object)exportsObject);
        return moduleObject;
    }
}

