/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.math;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.math.MathOperation;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class AtanhNode
extends MathOperation {
    public AtanhNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static double atanh(double x) {
        if (JSRuntime.isNegativeZero(x)) {
            return -0.0;
        }
        return Math.log((1.0 + x) / (1.0 - x)) / 2.0;
    }

    @Specialization
    protected double atanh(Object a) {
        return AtanhNode.atanh(this.toDouble(a));
    }
}

