/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.AbstractAwaitNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.ResumableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public class AsyncIteratorNextNode
extends AbstractAwaitNode
implements ResumableNode.WithIntState {
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsObjectNode isObjectNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected AsyncIteratorNextNode(JSContext context, int stateSlot, JavaScriptNode iterator, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        super(context, stateSlot, iterator, asyncContextNode, asyncResultNode);
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsObjectNode.create();
    }

    public static JavaScriptNode create(JSContext context, int stateSlot, JavaScriptNode iterator, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        return new AsyncIteratorNextNode(context, stateSlot, iterator, asyncContextNode, asyncResultNode);
    }

    private Object executeBegin(VirtualFrame frame) {
        IteratorRecord iteratorRecord = (IteratorRecord)this.expression.execute(frame);
        Object next = iteratorRecord.getNextMethod();
        JSDynamicObject iterator = iteratorRecord.getIterator();
        Object nextResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, next));
        this.setStateAsInt(frame, this.stateSlot, 1);
        return this.suspendAwait(frame, nextResult);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int index = this.getStateAsIntAndReset(frame, this.stateSlot);
        if (index == 0) {
            return this.executeBegin(frame);
        }
        Object result = this.resumeAwait(frame);
        if (!this.isObjectNode.executeBoolean(result)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(result, this);
        }
        return result;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new AsyncIteratorNextNode(this.context, this.stateSlot, AsyncIteratorNextNode.cloneUninitialized(this.expression, materializedTags), AsyncIteratorNextNode.cloneUninitialized(this.readAsyncContextNode, materializedTags), AsyncIteratorNextNode.cloneUninitialized(this.readAsyncResultNode, materializedTags));
    }
}

