/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Objects;
import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.Frame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.ExplodeLoop;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.ClearFrameSlotNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.ClearFrameSlotRangeNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSFrameUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public class ClearFrameSlotsNode
extends JavaScriptNode {
    @Node.Child
    private ScopeFrameNode scopeFrameNode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] slots;

    protected ClearFrameSlotsNode(ScopeFrameNode scopeFrameNode, int[] slots) {
        this.scopeFrameNode = Objects.requireNonNull(scopeFrameNode);
        this.slots = Objects.requireNonNull(slots);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        Frame scopeFrame = this.scopeFrameNode.executeFrame(frame);
        for (int slot : this.slots) {
            ClearFrameSlotsNode.clearSlot(scopeFrame, slot);
        }
        return Undefined.instance;
    }

    static void clearSlot(Frame scopeFrame, int slot) {
        assert (JSFrameUtil.hasTemporalDeadZone(scopeFrame.getFrameDescriptor(), slot)) : slot;
        scopeFrame.clear(slot);
    }

    public static JavaScriptNode create(ScopeFrameNode scopeFrameNode, int[] slots) {
        if (slots.length == 1) {
            return new ClearFrameSlotNode(scopeFrameNode, slots[0]);
        }
        return new ClearFrameSlotsNode(scopeFrameNode, slots);
    }

    public static JavaScriptNode createRange(ScopeFrameNode scopeFrameNode, int start, int end) {
        return new ClearFrameSlotRangeNode(scopeFrameNode, start, end);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ClearFrameSlotsNode.create(this.scopeFrameNode, this.slots);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Undefined.class;
    }
}

