/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Objects;
import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JSNodeUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.ReadNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GlobalPropertyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GlobalScopeLookupNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSTargetableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.VarWrapperNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.WriteNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.WritePropertyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;

public final class GlobalScopeVarWrapperNode
extends VarWrapperNode
implements ReadNode,
WriteNode {
    private final TruffleString varName;
    @Node.Child
    private JavaScriptNode dynamicScopeNode;
    @Node.Child
    private JavaScriptNode defaultDelegate;
    @Node.Child
    private JSTargetableNode scopeAccessNode;
    @Node.Child
    private GlobalScopeLookupNode scopeHasBinding;

    public GlobalScopeVarWrapperNode(TruffleString varName, JavaScriptNode defaultDelegate, JavaScriptNode dynamicScope, JSTargetableNode scopeAccessNode) {
        this.varName = varName;
        this.dynamicScopeNode = dynamicScope;
        this.defaultDelegate = Objects.requireNonNull(defaultDelegate);
        this.scopeAccessNode = scopeAccessNode;
        this.scopeHasBinding = GlobalScopeLookupNode.create(varName, this.isWrite());
    }

    @Override
    public JavaScriptNode getDelegateNode() {
        return this.defaultDelegate;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return false;
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    private boolean isWrite() {
        return this.scopeAccessNode instanceof WritePropertyNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object dynamicScope = this.dynamicScopeNode.execute(frame);
        if (this.scopeHasBinding.execute(dynamicScope)) {
            if (this.isWrite()) {
                Object value = this.getRhs().execute(frame);
                ((WritePropertyNode)this.scopeAccessNode).executeWithValue(dynamicScope, value);
                return value;
            }
            return this.scopeAccessNode.executeWithTarget(frame, dynamicScope);
        }
        return this.defaultDelegate.execute(frame);
    }

    @Override
    public void executeWrite(VirtualFrame frame, Object value) {
        throw Errors.shouldNotReachHere();
    }

    @Override
    public JavaScriptNode getRhs() {
        return ((WriteNode)((Object)JSNodeUtil.getWrappedNode(this.defaultDelegate))).getRhs();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GlobalScopeVarWrapperNode(this.varName, GlobalScopeVarWrapperNode.cloneUninitialized(this.defaultDelegate, materializedTags), GlobalScopeVarWrapperNode.cloneUninitialized(this.dynamicScopeNode, materializedTags), GlobalScopeVarWrapperNode.cloneUninitialized(this.scopeAccessNode, materializedTags));
    }

    public void setMethod() {
        if (this.defaultDelegate instanceof GlobalPropertyNode) {
            ((GlobalPropertyNode)this.defaultDelegate).setMethod();
        }
    }
}

