/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public class IteratorNextUnaryNode
extends JavaScriptNode {
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsObjectNode isObjectNode;
    @Node.Child
    private JavaScriptNode iteratorNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected IteratorNextUnaryNode(JavaScriptNode iteratorNode) {
        this.iteratorNode = iteratorNode;
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsObjectNode.create();
    }

    public static JavaScriptNode create(JavaScriptNode iteratorNode) {
        return new IteratorNextUnaryNode(iteratorNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        IteratorRecord iterator = (IteratorRecord)this.iteratorNode.execute(frame);
        return this.execute(iterator);
    }

    public Object execute(IteratorRecord iteratorRecord) {
        Object next;
        JSDynamicObject iterator = iteratorRecord.getIterator();
        Object nextResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, next = iteratorRecord.getNextMethod()));
        if (!this.isObjectNode.executeBoolean(nextResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIteratorResultNotObject(nextResult, this);
        }
        return nextResult;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorNextUnaryNode.create(IteratorNextUnaryNode.cloneUninitialized(this.iteratorNode, materializedTags));
    }
}

