/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeCost;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.HiddenKey;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GetMethodNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSProxyPropertySetNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSUncheckedProxyHandlerObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.JSClassProfile;

@NodeInfo(cost=NodeCost.NONE)
public abstract class JSProxyPropertySetNode
extends JavaScriptBaseNode {
    private final boolean isStrict;
    @Node.Child
    private JSFunctionCallNode call;
    @Node.Child
    private JSToBooleanNode toBoolean;
    @Node.Child
    protected GetMethodNode trapGet;
    @Node.Child
    private JSToPropertyKeyNode toPropertyKeyNode;
    @Node.Child
    private InteropLibrary interopNode;
    @Node.Child
    private ExportValueNode exportValueNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected JSProxyPropertySetNode(JSContext context, boolean isStrict) {
        this.call = JSFunctionCallNode.createCall();
        this.trapGet = GetMethodNode.create(context, JSProxy.SET);
        this.toBoolean = JSToBooleanNode.create();
        this.isStrict = isStrict;
    }

    public abstract boolean executeWithReceiverAndValue(Object var1, Object var2, Object var3, Object var4);

    public abstract boolean executeWithReceiverAndValueInt(Object var1, Object var2, int var3, Object var4);

    public static JSProxyPropertySetNode create(JSContext context, boolean isStrict) {
        return JSProxyPropertySetNodeGen.create(context, isStrict);
    }

    @Specialization
    protected boolean doGeneric(JSDynamicObject proxy, Object receiver, Object value, Object key, @Cached(value="createBinaryProfile()") ConditionProfile hasTrap, @Cached JSClassProfile targetClassProfile) {
        assert (JSProxy.isJSProxy(proxy));
        assert (!(key instanceof HiddenKey));
        Object propertyKey = this.toPropertyKey(key);
        JSDynamicObject handler = JSProxy.getHandlerChecked(proxy, this.errorBranch);
        Object target = JSProxy.getTarget(proxy);
        Object trapFun = this.trapGet.executeWithTarget(handler);
        if (hasTrap.profile(trapFun == Undefined.instance)) {
            if (JSDynamicObject.isJSDynamicObject(target)) {
                return JSObject.setWithReceiver((JSDynamicObject)target, propertyKey, value, receiver, this.isStrict, targetClassProfile, (Node)this);
            }
            this.truffleWrite(target, propertyKey, value);
            return true;
        }
        Object trapResult = this.call.executeCall(JSArguments.create(handler, trapFun, target, propertyKey, value, receiver));
        boolean booleanTrapResult = this.toBoolean.executeBoolean(trapResult);
        if (!booleanTrapResult) {
            this.errorBranch.enter();
            if (this.isStrict) {
                throw Errors.createTypeErrorTrapReturnedFalsish(JSProxy.SET, propertyKey);
            }
            return false;
        }
        if (handler instanceof JSUncheckedProxyHandlerObject) {
            return true;
        }
        return JSProxy.checkProxySetTrapInvariants(proxy, propertyKey, value);
    }

    private void truffleWrite(Object obj, Object key, Object value) {
        InteropLibrary interop = this.interopNode;
        ExportValueNode exportValue = this.exportValueNode;
        if (interop == null || exportValue == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.interopNode = interop = this.insert(InteropLibrary.getFactory().createDispatched(5));
            this.exportValueNode = exportValue = this.insert(ExportValueNode.create());
        }
        JSInteropUtil.writeMember(obj, key, value, interop, exportValue, this);
    }

    Object toPropertyKey(Object key) {
        if (this.toPropertyKeyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toPropertyKeyNode = this.insert(JSToPropertyKeyNode.create());
        }
        return this.toPropertyKeyNode.execute(key);
    }
}

