/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.array;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.array.ArrayCreateNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArrayObject;

@ImportStatic(value={JSRuntime.class, Integer.class})
public abstract class ArrayCreateNode
extends JavaScriptBaseNode {
    private final JSContext context;

    protected ArrayCreateNode(JSContext context) {
        this.context = context;
    }

    public static ArrayCreateNode create(JSContext context) {
        return ArrayCreateNodeGen.create(context);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length <= MAX_VALUE"})
    protected JSArrayObject doDefault(long length) {
        return JSArray.createEmptyChecked(this.context, this.getRealm(), length);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length > MAX_VALUE"})
    protected JSArrayObject doLargeLength(long length) {
        return JSArray.createSparseArray(this.context, this.getRealm(), length);
    }

    @Specialization(guards={"!isValidArrayLength(length)"})
    protected JSArrayObject doInvalidLength(long length) {
        throw Errors.createRangeErrorInvalidArrayLength();
    }

    public abstract JSArrayObject execute(long var1);
}

