/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.lang.JavaScriptLanguage;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSConcatStringsNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;

public abstract class JSConcatStringsNode
extends JavaScriptBaseNode {
    protected final int stringLengthLimit;

    protected JSConcatStringsNode(int stringLengthLimit) {
        this.stringLengthLimit = stringLengthLimit;
    }

    public static JSConcatStringsNode create(int stringLengthLimit) {
        return JSConcatStringsNodeGen.create(stringLengthLimit);
    }

    public static JSConcatStringsNode create() {
        return JSConcatStringsNode.create(JavaScriptLanguage.getCurrentLanguage().getJSContext().getStringLengthLimit());
    }

    public abstract TruffleString executeTString(TruffleString var1, TruffleString var2);

    @Specialization
    protected final TruffleString doConcat(TruffleString left, TruffleString right, @Cached BranchProfile errorBranch, @Cached TruffleString.ConcatNode concatNode) {
        this.validateStringLength(Strings.length(left) + Strings.length(right), errorBranch);
        return Strings.concat(concatNode, left, right);
    }

    private void validateStringLength(int resultLength, BranchProfile errorBranch) {
        if (CompilerDirectives.injectBranchProbability(1.0E-4, resultLength < 0 || resultLength > this.stringLengthLimit)) {
            errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength(this);
        }
    }
}

