/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast;

import java.math.BigInteger;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class JSNumberToBigIntNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    public final BigInt executeBigInt(Object value) {
        return (BigInt)this.execute(value);
    }

    public static JSNumberToBigIntNode create() {
        return JSNumberToBigIntNodeGen.create();
    }

    @Specialization
    protected BigInt doInteger(int value) {
        return BigInt.valueOf(value);
    }

    protected boolean doubleRepresentsSameValueAsLong(double value) {
        return JSRuntime.doubleIsRepresentableAsLong(value) && value != 9.223372036854776E18;
    }

    @Specialization(guards={"doubleRepresentsSameValueAsLong(value)"})
    protected BigInt doDoubleAsLong(double value) {
        return BigInt.valueOf((long)value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!doubleRepresentsSameValueAsLong(value)"})
    protected BigInt doDoubleOther(double value) {
        if (!JSRuntime.isInteger(value)) {
            throw Errors.createRangeError("BigInt out of range");
        }
        long bits = Double.doubleToRawLongBits(value);
        boolean negative = (bits & Long.MIN_VALUE) != 0L;
        int exponentOffset = 1023;
        int mantissaLength = 52;
        int exponent = (int)((bits & 0x7FF0000000000000L) >> mantissaLength) - exponentOffset - mantissaLength;
        long mantissa = bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        BigInteger bigInteger = BigInteger.valueOf(negative ? -mantissa : mantissa).shiftLeft(exponent);
        return new BigInt(bigInteger);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static BigInt doNull(Object value) {
        return BigInt.ZERO;
    }
}

