/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.RepeatingNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JSNodeUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToBooleanUnaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.ResumableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.StatementNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSInterruptedExecutionException;

abstract class AbstractRepeatingNode
extends JavaScriptNode
implements RepeatingNode,
ResumableNode {
    @Node.Child
    protected JavaScriptNode conditionNode;
    @Node.Child
    protected JavaScriptNode bodyNode;

    AbstractRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
        this.conditionNode = JSToBooleanUnaryNode.create(condition);
        this.bodyNode = body;
    }

    protected final boolean executeCondition(VirtualFrame frame) {
        return StatementNode.executeConditionAsBoolean(frame, this.conditionNode);
    }

    protected final void executeBody(VirtualFrame frame) {
        this.bodyNode.executeVoid(frame);
        if (CompilerDirectives.inInterpreter()) {
            this.checkThreadInterrupted();
        }
    }

    private void checkThreadInterrupted() {
        CompilerAsserts.neverPartOfCompilation("do not check thread interruption from compiled code");
        if (Thread.interrupted()) {
            throw new JSInterruptedExecutionException("Thread was interrupted.", this);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeRepeating(frame);
    }

    public static boolean materializationNeeded(RepeatingNode repeatingNode) {
        if (!(repeatingNode instanceof AbstractRepeatingNode)) {
            return false;
        }
        assert (repeatingNode instanceof AbstractRepeatingNode);
        JavaScriptNode rnBodyNode = ((AbstractRepeatingNode)repeatingNode).bodyNode;
        return !JSNodeUtil.isTaggedNode(rnBodyNode);
    }
}

