/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.FrameDescriptor;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeCost;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.AbstractBodyNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.FunctionRootNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.DeclareTagProvider;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.JSTags;

@NodeInfo(cost=NodeCost.NONE)
public class FunctionBodyNode
extends AbstractBodyNode {
    @Node.Child
    private JavaScriptNode body;

    public FunctionBodyNode(JavaScriptNode body) {
        this.body = body;
    }

    public static FunctionBodyNode create(JavaScriptNode body) {
        return new FunctionBodyNode(body);
    }

    public JavaScriptNode getBody() {
        return this.body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.body.execute(frame);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return FunctionBodyNode.create(FunctionBodyNode.cloneUninitialized(this.body, materializedTags));
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.DeclareTag.class) && !DeclareTagProvider.isMaterializedFrameProvider(this)) {
            assert (this.getRootNode() instanceof FunctionRootNode) : "Malformed AST";
            FrameDescriptor frameDescriptor = this.getRootNode().getFrameDescriptor();
            JavaScriptNode materialized = DeclareTagProvider.createMaterializedFunctionBodyNode(this, FunctionBodyNode.cloneUninitialized(this.body, materializedTags), frameDescriptor);
            materialized.setSourceSection(this.getSourceSection());
            return materialized;
        }
        return this;
    }
}

