/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Symbol;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunction;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;

public class SetFunctionNameNode
extends JavaScriptBaseNode {
    private final ConditionProfile isSymbolProfile = ConditionProfile.createBinaryProfile();

    protected SetFunctionNameNode() {
    }

    public static SetFunctionNameNode create() {
        return new SetFunctionNameNode();
    }

    public Object execute(Object functionValue, Object propertyKey) {
        return this.execute(functionValue, propertyKey, null);
    }

    public Object execute(Object functionValue, Object propertyKey, TruffleString prefix) {
        TruffleString name;
        assert (JSFunction.isJSFunction(functionValue));
        assert (JSRuntime.isPropertyKey(propertyKey));
        TruffleString truffleString = name = this.isSymbolProfile.profile(propertyKey instanceof Symbol) ? ((Symbol)propertyKey).toFunctionNameString() : (TruffleString)propertyKey;
        if (prefix != null && !Strings.isEmpty(prefix)) {
            name = SetFunctionNameNode.concatenate(prefix, name);
        }
        return SetFunctionNameNode.setFunctionName((JSFunctionObject)functionValue, name);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString concatenate(TruffleString prefix, TruffleString name) {
        return Strings.concatAll(prefix, Strings.SPACE, name);
    }

    private static Object setFunctionName(JSFunctionObject functionValue, TruffleString name) {
        PropertyDescriptor propDesc = PropertyDescriptor.createData(name, false, false, true);
        JSRuntime.definePropertyOrThrow(functionValue, JSFunction.NAME, propDesc);
        return functionValue;
    }
}

