/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.GenerateUncached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.lang.JavaScriptLanguage;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSConfig;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Symbol;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.interop.JSIteratorWrapper;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;

@ImportStatic(value={JSConfig.class, JSRuntime.class, Symbol.class, Strings.class})
@GenerateUncached
public abstract class JSInteropGetIteratorNode
extends JSInteropCallNode {
    JSInteropGetIteratorNode() {
    }

    public static JSInteropGetIteratorNode create() {
        return JSInteropGetIteratorNodeGen.create();
    }

    public final boolean hasIterator(JSObject receiver, JavaScriptLanguage language) {
        try {
            return (Boolean)this.execute(receiver, language, true);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.shouldNotReachHere(e);
        }
    }

    public final Object getIterator(JSObject receiver, JavaScriptLanguage language) throws UnsupportedMessageException {
        return this.execute(receiver, language, false);
    }

    protected abstract Object execute(JSObject var1, JavaScriptLanguage var2, boolean var3) throws UnsupportedMessageException;

    @Specialization
    Object doDefault(JSObject receiver, JavaScriptLanguage language, boolean hasIteratorCheck, @Cached(value="create(SYMBOL_ITERATOR, language.getJSContext())", uncached="getUncachedProperty()") PropertyGetNode iteratorPropertyGetNode, @Cached IsCallableNode isCallableNode, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached(value="create(NEXT, language.getJSContext())", uncached="getUncachedProperty()") PropertyGetNode nextPropertyGetNode, @Cached BranchProfile exceptionBranch) throws UnsupportedMessageException {
        boolean hasIterator;
        Object method = JSInteropGetIteratorNode.getProperty(receiver, iteratorPropertyGetNode, Symbol.SYMBOL_ITERATOR, null);
        boolean bl = hasIterator = method != null && isCallableNode.executeBoolean(method);
        if (hasIteratorCheck) {
            return hasIterator;
        }
        if (hasIterator) {
            JSObject jsIterator;
            Object nextMethod;
            Object iterator = callNode.executeCall(JSArguments.createZeroArg(receiver, method));
            if (iterator instanceof JSObject && (nextMethod = JSInteropGetIteratorNode.getProperty(jsIterator = (JSObject)iterator, nextPropertyGetNode, Strings.NEXT, null)) != null && isCallableNode.executeBoolean(nextMethod)) {
                return JSIteratorWrapper.create(IteratorRecord.create(jsIterator, nextMethod));
            }
            exceptionBranch.enter();
            throw Errors.createTypeErrorNotIterable(receiver, null);
        }
        exceptionBranch.enter();
        throw UnsupportedMessageException.create();
    }
}

