/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.promise;

import java.io.PrintWriter;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContextOptions;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.PromiseRejectionTracker;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSError;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public class BuiltinPromiseRejectionTracker
implements PromiseRejectionTracker {
    private final JSContext context;
    private final JSContextOptions.UnhandledRejectionsTrackingMode mode;
    private final Set<JSDynamicObject> pendingUnhandledRejections = new LinkedHashSet<JSDynamicObject>();
    private final Deque<PromiseChainInfoRecord> asyncHandledRejections = new LinkedList<PromiseChainInfoRecord>();
    private final Map<JSDynamicObject, PromiseChainInfoRecord> maybeUnhandledPromises = new WeakHashMap<JSDynamicObject, PromiseChainInfoRecord>();

    public BuiltinPromiseRejectionTracker(JSContext context, JSContextOptions.UnhandledRejectionsTrackingMode mode) {
        assert (mode != JSContextOptions.UnhandledRejectionsTrackingMode.NONE);
        this.context = context;
        this.mode = mode;
    }

    @Override
    public void promiseRejected(JSDynamicObject promise, Object reason) {
        CompilerAsserts.neverPartOfCompilation();
        this.maybeUnhandledPromises.put(promise, new PromiseChainInfoRecord(reason, false));
        this.pendingUnhandledRejections.add(promise);
        this.context.getLanguage().getPromiseJobsQueueEmptyAssumption().invalidate("Potential unhandled rejection");
    }

    @Override
    public void promiseRejectionHandled(JSDynamicObject promise) {
        CompilerAsserts.neverPartOfCompilation();
        PromiseChainInfoRecord promiseInfo = this.maybeUnhandledPromises.get(promise);
        if (promiseInfo != null) {
            this.maybeUnhandledPromises.remove(promise);
            this.pendingUnhandledRejections.remove(promise);
            if (promiseInfo.warned) {
                this.asyncHandledRejections.add(promiseInfo);
            }
        }
    }

    @Override
    public void promiseRejectedAfterResolved(JSDynamicObject promise, Object value) {
    }

    @Override
    public void promiseResolvedAfterResolved(JSDynamicObject promise, Object value) {
    }

    @Override
    public void promiseReactionJobsProcessed() {
        CompilerAsserts.neverPartOfCompilation();
        JSRealm realm = JSRealm.get(null);
        assert (realm.getContext() == this.context);
        while (!this.asyncHandledRejections.isEmpty()) {
            PromiseChainInfoRecord info = this.asyncHandledRejections.removeFirst();
            if (this.mode != JSContextOptions.UnhandledRejectionsTrackingMode.WARN) continue;
            PrintWriter out = realm.getErrorWriter();
            out.println("[GraalVM JavaScript Warning] Promise rejection was handled asynchronously: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
            out.flush();
        }
        while (!this.pendingUnhandledRejections.isEmpty()) {
            JSDynamicObject unhandledPromise = this.pendingUnhandledRejections.iterator().next();
            this.pendingUnhandledRejections.remove(unhandledPromise);
            PromiseChainInfoRecord info = this.maybeUnhandledPromises.get(unhandledPromise);
            if (info == null) continue;
            info.warned = true;
            if (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.HANDLER) {
                Object handler = realm.getUnhandledPromiseRejectionHandler();
                if (handler == null) continue;
                JSRuntime.call(handler, Undefined.instance, new Object[]{info.reason, unhandledPromise});
                continue;
            }
            if (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.WARN) {
                PrintWriter out = realm.getErrorWriter();
                out.println("[GraalVM JavaScript Warning] Unhandled promise rejection: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
                out.flush();
                continue;
            }
            assert (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.THROW);
            InteropLibrary interop = InteropLibrary.getUncached(info.reason);
            if (interop.isException(info.reason)) {
                try {
                    interop.throwException(info.reason);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw Errors.createError("Unhandled promise rejection: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
        }
    }

    private static String formatError(Object error) {
        block8: {
            CompilerAsserts.neverPartOfCompilation();
            InteropLibrary interopExc = InteropLibrary.getUncached(error);
            InteropLibrary interopStr = InteropLibrary.getUncached();
            if (interopExc.isException(error)) {
                try {
                    String message = null;
                    if (interopExc.hasExceptionMessage(error)) {
                        message = interopStr.asString(interopExc.getExceptionMessage(error));
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Objects.requireNonNullElse(message, "Error"));
                    if (interopExc.hasExceptionStackTrace(error)) {
                        Object stackTrace = interopExc.getExceptionStackTrace(error);
                        InteropLibrary interopST = InteropLibrary.getUncached(stackTrace);
                        long length = interopST.getArraySize(stackTrace);
                        for (long i = 0L; i < length; ++i) {
                            Object stackTraceElement = interopST.readArrayElement(stackTrace, i);
                            InteropLibrary interopSTE = InteropLibrary.getUncached(stackTraceElement);
                            String name = null;
                            SourceSection sourceLocation = null;
                            if (interopSTE.hasExecutableName(stackTraceElement)) {
                                name = interopStr.asString(interopSTE.getExecutableName(stackTraceElement));
                            }
                            if (interopSTE.hasSourceLocation(stackTraceElement)) {
                                sourceLocation = interopSTE.getSourceLocation(stackTraceElement);
                            }
                            if (name == null && sourceLocation == null) continue;
                            sb.append('\n');
                            sb.append("    at ");
                            sb.append(Objects.requireNonNullElse(name, JSError.ANONYMOUS_FUNCTION_NAME));
                            if (sourceLocation == null) continue;
                            sb.append(" (").append(BuiltinPromiseRejectionTracker.formatSourceLocation(sourceLocation)).append(")");
                        }
                    }
                    return sb.toString();
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return JSRuntime.safeToString(error).toString();
    }

    private static String formatSourceLocation(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "Unknown";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sourceSection.getSource().getName());
        sb.append(":");
        sb.append(sourceSection.getStartLine());
        if (sourceSection.getStartLine() < sourceSection.getEndLine()) {
            sb.append("-").append(sourceSection.getEndLine());
        }
        sb.append(":");
        sb.append(sourceSection.getCharIndex());
        if (sourceSection.getCharLength() > 1) {
            sb.append("-").append(sourceSection.getCharEndIndex() - 1);
        }
        return sb.toString();
    }

    private static class PromiseChainInfoRecord {
        private final Object reason;
        private boolean warned;

        PromiseChainInfoRecord(Object reason, boolean warned) {
            this.reason = reason;
            this.warned = warned;
        }
    }
}

