/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GetMethodNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Boundaries;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalConstants;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalCalendarFieldsNode
extends JavaScriptBaseNode {
    private final JSContext ctx;
    @Node.Child
    private GetMethodNode getMethodFieldsNode;
    @Node.Child
    private JSFunctionCallNode callFieldsNode;
    private final ConditionProfile fieldsUndefined = ConditionProfile.createBinaryProfile();

    protected TemporalCalendarFieldsNode(JSContext ctx) {
        this.ctx = ctx;
        this.getMethodFieldsNode = GetMethodNode.create(ctx, TemporalConstants.FIELDS);
    }

    public static TemporalCalendarFieldsNode create(JSContext ctx) {
        return TemporalCalendarFieldsNodeGen.create(ctx);
    }

    public abstract List<TruffleString> execute(JSDynamicObject var1, List<TruffleString> var2);

    @Specialization
    protected List<TruffleString> calendarFields(JSDynamicObject calendar, List<TruffleString> strings) {
        Object fields = this.getMethodFieldsNode.executeWithTarget(calendar);
        if (this.fieldsUndefined.profile(fields == Undefined.instance)) {
            return strings;
        }
        JSDynamicObject fieldsArray = JSArray.createConstant(this.ctx, this.getRealm(), Boundaries.listToArray(strings));
        fieldsArray = this.callFields(fields, calendar, new Object[]{fieldsArray});
        return TemporalUtil.iterableToListOfTypeString(fieldsArray);
    }

    private JSDynamicObject callFields(Object fieldsFn, JSDynamicObject calendar, Object[] args) {
        if (this.callFieldsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callFieldsNode = this.insert(JSFunctionCallNode.createCall());
        }
        return TemporalUtil.toDynamicObject(this.callFieldsNode.executeCall(JSArguments.create(calendar, fieldsFn, args)));
    }
}

