/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal.ToLimitedTemporalDurationNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Boundaries;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalErrors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToLimitedTemporalDurationNode
extends JavaScriptBaseNode {
    private final ConditionProfile isObjectProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile hasDisallowedFields = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorBranch = BranchProfile.create();

    protected ToLimitedTemporalDurationNode() {
    }

    public static ToLimitedTemporalDurationNode create() {
        return ToLimitedTemporalDurationNodeGen.create();
    }

    public abstract JSTemporalDurationRecord executeDynamicObject(Object var1, List<TruffleString> var2);

    @Specialization
    protected JSTemporalDurationRecord toLimitedTemporalDuration(Object temporalDurationLike, List<TruffleString> disallowedFields, @Cached(value="create()") IsObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toStringNode) {
        JSTemporalDurationRecord d;
        if (this.isObjectProfile.profile(!isObjectNode.executeBoolean(temporalDurationLike))) {
            TruffleString str = toStringNode.executeString(temporalDurationLike);
            d = JSTemporalDuration.parseTemporalDurationString(str);
        } else {
            d = JSTemporalDuration.toTemporalDurationRecord((JSDynamicObject)temporalDurationLike);
        }
        if (this.hasDisallowedFields.profile(disallowedFields != TemporalUtil.listEmpty)) {
            for (TemporalUtil.UnitPlural unit : TemporalUtil.DURATION_PROPERTIES) {
                double value = TemporalUtil.getPropertyFromRecord(d, unit);
                if (value == 0.0 || !Boundaries.listContains(disallowedFields, unit.toTruffleString())) continue;
                this.errorBranch.enter();
                throw TemporalErrors.createRangeErrorDisallowedField(unit.toTruffleString());
            }
        }
        return d;
    }
}

