/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSClass;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSGlobalObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSShape;

public final class JSGlobal
extends JSNonProxy {
    public static final TruffleString CLASS_NAME = Strings.constant("global");
    public static final TruffleString EVAL_NAME = Strings.constant("eval");
    public static final JSGlobal INSTANCE = new JSGlobal();

    private JSGlobal() {
    }

    public static JSObject create(JSRealm realm, JSDynamicObject objectPrototype) {
        CompilerAsserts.neverPartOfCompilation();
        JSContext context = realm.getContext();
        JSObjectFactory factory = context.getGlobalObjectFactory();
        JSGlobalObject global = new JSGlobalObject(factory.getShape(realm));
        factory.initProto(global, objectPrototype);
        JSObjectUtil.putToStringTag(global, CLASS_NAME);
        return global;
    }

    public static Shape makeGlobalObjectShape(JSContext context, JSDynamicObject objectPrototype) {
        boolean singleContext = !context.isMultiContext();
        Shape globalObjectShape = JSShape.newBuilder(context, INSTANCE, singleContext ? objectPrototype : null).propertyAssumptions(singleContext).build();
        if (singleContext) {
            globalObjectShape = Shape.newBuilder(globalObjectShape).addConstantProperty(JSObject.HIDDEN_PROTO, objectPrototype, 0).build();
        }
        return globalObjectShape;
    }

    public static JSObject createGlobalScope(JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        return new JSGlobalObject(context.getGlobalScopeShape());
    }

    public static boolean isJSGlobalObject(Object obj) {
        return JSDynamicObject.isJSDynamicObject(obj) && JSGlobal.isJSGlobalObject((JSDynamicObject)obj);
    }

    public static boolean isJSGlobalObject(JSDynamicObject obj) {
        return JSGlobal.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setPrototypeOf(JSDynamicObject thisObj, JSDynamicObject newPrototype) {
        if (JSObject.getPrototype(thisObj) == newPrototype) {
            return true;
        }
        JSObject.getJSContext(thisObj).getGlobalObjectPristineAssumption().invalidate();
        return super.setPrototypeOf(thisObj, newPrototype);
    }
}

