/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins;

import java.lang.ref.WeakReference;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.WeakRefPrototypeBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSWeakRefObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWeakRef
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWeakRef INSTANCE = new JSWeakRef();
    public static final TruffleString CLASS_NAME = Strings.constant("WeakRef");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("WeakRef.prototype");

    private JSWeakRef() {
    }

    public static JSWeakRefObject create(JSContext context, JSRealm realm, Object referent) {
        TruffleWeakReference<Object> weakReference = new TruffleWeakReference<Object>(referent);
        JSObjectFactory factory = context.getWeakRefFactory();
        JSWeakRefObject obj = factory.initProto(new JSWeakRefObject(factory.getShape(realm), weakReference), realm);
        context.addWeakRefTargetToSet(referent);
        return context.trackAllocation(obj);
    }

    public static TruffleWeakReference<?> getInternalWeakRef(JSDynamicObject obj) {
        assert (JSWeakRef.isJSWeakRef(obj));
        return ((JSWeakRefObject)obj).getWeakReference();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSContext ctx = realm.getContext();
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WeakRefPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public TruffleString toDisplayStringImpl(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return Strings.addBrackets(this.getClassName());
    }

    public static boolean isJSWeakRef(Object obj) {
        return obj instanceof JSWeakRefObject;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWeakRefPrototype();
    }

    public static final class TruffleWeakReference<T>
    extends WeakReference<T> {
        public TruffleWeakReference(T t) {
            super(t);
        }
    }
}

