/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal;

import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ExportLibrary(value=InteropLibrary.class)
public class JSTemporalInstantObject
extends JSNonProxyObject {
    private final BigInt nanoseconds;

    protected JSTemporalInstantObject(Shape shape, BigInt nanoseconds) {
        super(shape);
        this.nanoseconds = nanoseconds;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Instant asInstant() {
        BigInteger[] res = this.nanoseconds.bigIntegerValue().divideAndRemainder(TemporalUtil.BI_10_POW_9);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage
    final boolean isTimeZone() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final ZoneId asTimeZone() {
        return ZoneId.of("UTC");
    }

    @ExportMessage
    final boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final LocalDate asDate() {
        LocalDate ld = LocalDate.ofInstant(this.asInstant(), this.asTimeZone());
        return ld;
    }

    @ExportMessage
    final boolean isTime() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final LocalTime asTime() {
        LocalTime lt = LocalTime.ofInstant(this.asInstant(), this.asTimeZone());
        return lt;
    }
}

