/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal;

import java.time.LocalDate;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.TemporalCalendar;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.TemporalDay;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.TemporalMonth;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.TemporalYear;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public class JSTemporalPlainDateObject
extends JSNonProxyObject
implements TemporalMonth,
TemporalYear,
TemporalDay,
TemporalCalendar {
    private final int year;
    private final int month;
    private final int day;
    private final JSDynamicObject calendar;

    public JSTemporalPlainDateObject(Shape shape, int year, int month, int day, JSDynamicObject calendar) {
        super(shape);
        this.year = year;
        this.month = month;
        this.day = day;
        this.calendar = calendar;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public JSDynamicObject getCalendar() {
        return this.calendar;
    }

    @ExportMessage
    final boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final LocalDate asDate() {
        LocalDate ld = LocalDate.of(this.year, this.month, this.day);
        return ld;
    }
}

