/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.polyglot;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.ExplodeLoop;

final class FinalIntMap {
    @CompilerDirectives.CompilationFinal
    Entry first;

    FinalIntMap() {
    }

    @ExplodeLoop
    int get(Object key) {
        Entry current = this.first;
        while (current != null) {
            if (current.key == key) {
                return current.value;
            }
            current = current.next;
        }
        return -1;
    }

    void put(Object key, int value) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.get(key) == -1) : "replace not supported by this map implementation";
        assert (value >= 0) : "only positive integers supported";
        Entry prev = null;
        Entry current = this.first;
        while (current != null) {
            prev = current;
            current = current.next;
        }
        Entry entry = new Entry(key, value);
        if (prev == null) {
            assert (current == this.first);
            this.first = entry;
        } else {
            prev.next = entry;
        }
    }

    static final class Entry {
        final Object key;
        final int value;
        @CompilerDirectives.CompilationFinal
        Entry next;

        Entry(Object key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

