/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.nodes.input;

import java.util.Arrays;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.ArrayUtils;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.AbstractTruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.nodes.input.InputEqualsNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.string.Encodings;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.util.TRegexGuards;

@ImportStatic(value={TRegexGuards.class})
public abstract class InputEqualsNode
extends Node {
    public static InputEqualsNode create() {
        return InputEqualsNodeGen.create();
    }

    public abstract boolean execute(Object var1, Object var2, Object var3, Encodings.Encoding var4);

    @Specialization(guards={"mask == null"})
    public boolean doBytes(byte[] input, byte[] string, Object mask, Encodings.Encoding encoding) {
        return Arrays.equals(input, string);
    }

    @Specialization(guards={"mask != null"})
    public boolean doBytesMask(byte[] input, byte[] string, byte[] mask, Encodings.Encoding encoding) {
        return input.length == string.length && ArrayUtils.regionEqualsWithOrMask(input, 0, string, 0, mask.length, mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doString(String input, String string, Object mask, Encodings.Encoding encoding) {
        return input.equals(string);
    }

    @Specialization(guards={"mask != null"})
    public boolean doStringMask(String input, String string, String mask, Encodings.Encoding encoding) {
        return input.length() == string.length() && ArrayUtils.regionEqualsWithOrMask(input, 0, string, 0, mask.length(), mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doTString(TruffleString input, TruffleString string, Object mask, Encodings.Encoding encoding, @Cached TruffleString.RegionEqualByteIndexNode equalsNode) {
        int len2;
        int len1 = input.byteLength(encoding.getTStringEncoding());
        return len1 == (len2 = string.byteLength(encoding.getTStringEncoding())) && equalsNode.execute((AbstractTruffleString)input, 0, string, 0, len2, encoding.getTStringEncoding());
    }

    @Specialization(guards={"mask != null"})
    public boolean doTStringMask(TruffleString input, TruffleString string, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached TruffleString.RegionEqualByteIndexNode equalsNode) {
        int len2;
        int len1 = input.byteLength(encoding.getTStringEncoding());
        return len1 == (len2 = string.byteLength(encoding.getTStringEncoding())) && equalsNode.execute((AbstractTruffleString)input, 0, mask, 0, len2, encoding.getTStringEncoding());
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask == null"})
    public boolean doTruffleObjBytes(Object input, byte[] string, Object mask, Encodings.Encoding encoding, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, null, encoding, lengthNode, charAtNode);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask != null"})
    public boolean doTruffleObjBytesMask(Object input, byte[] string, byte[] mask, Encodings.Encoding encoding, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, mask, encoding, lengthNode, charAtNode);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask == null"})
    public boolean doTruffleObjString(Object input, String string, Object mask, Encodings.Encoding encoding, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, null, encoding, lengthNode, charAtNode);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)", "mask != null"})
    public boolean doTruffleObjStringMask(Object input, String string, String mask, Encodings.Encoding encoding, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, mask, encoding, lengthNode, charAtNode);
    }

    private static boolean equalsTruffleObj(Object input, String string, String mask, Encodings.Encoding encoding, InputLengthNode lengthNode, InputReadNode charAtNode) {
        if (lengthNode.execute(input, encoding) != string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (InputReadNode.readWithMask(input, i, mask, i, encoding, charAtNode) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsTruffleObj(Object input, byte[] string, byte[] mask, Encodings.Encoding encoding, InputLengthNode lengthNode, InputReadNode charAtNode) {
        if (lengthNode.execute(input, encoding) != string.length) {
            return false;
        }
        for (int i = 0; i < string.length; ++i) {
            if (InputReadNode.readWithMask(input, i, mask, i, encoding, charAtNode) == Byte.toUnsignedInt(string[i])) continue;
            return false;
        }
        return true;
    }
}

