/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.parser.flavors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.UnsupportedRegexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.charset.CodePointSet;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseFoldingData;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseUnfoldingTrie;
import kasuga.lib.vendor_modules.com.oracle.truffle.regex.tregex.parser.flavors.RubyRegexParser;

public class RubyCaseFolding {
    public static void caseFoldUnfoldString(int[] codepoints, CodePointSet encodingRange, RegexASTBuilder astBuilder) {
        RubyCaseFolding.caseFoldUnfoldString(codepoints, encodingRange, false, astBuilder);
    }

    public static void caseFoldUnfoldString(int[] codepoints, CodePointSet encodingRange, boolean dropAsciiOnStart, RegexASTBuilder astBuilder) {
        List<Integer> caseFolded = RubyCaseFolding.caseFold(codepoints);
        List<RubyCaseUnfoldingTrie.Unfolding> unfoldings = RubyCaseUnfoldingTrie.findUnfoldings(caseFolded);
        unfoldings = unfoldings.stream().filter(u -> encodingRange.contains(u.getCodepoint())).collect(Collectors.toList());
        astBuilder.pushGroup();
        int start = 0;
        int end = 0;
        int unfoldingsStartIndex = 0;
        int unfoldingsEndIndex = 0;
        for (int i = 0; i < unfoldings.size(); ++i) {
            RubyCaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(i);
            if (unfolding.getStart() >= end) {
                RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart);
                if (unfolding.getStart() > end) {
                    if (dropAsciiOnStart && end == 0 && RubyRegexParser.isAscii(caseFolded.get(end))) {
                        astBuilder.popGroup();
                        astBuilder.replaceCurTermWithDeadNode();
                        return;
                    }
                    RubyCaseFolding.addString(astBuilder, caseFolded.subList(end, unfolding.getStart()));
                }
                start = unfolding.getStart();
                unfoldingsStartIndex = i;
            }
            end = Math.max(end, unfolding.getEnd());
            unfoldingsEndIndex = i + 1;
        }
        RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart);
        if (end < caseFolded.size()) {
            if (dropAsciiOnStart && end == 0 && RubyRegexParser.isAscii(caseFolded.get(end))) {
                astBuilder.popGroup();
                astBuilder.replaceCurTermWithDeadNode();
                return;
            }
            RubyCaseFolding.addString(astBuilder, caseFolded.subList(end, caseFolded.size()));
        }
        astBuilder.popGroup();
    }

    private static List<Integer> caseFold(int[] codepoints) {
        ArrayList<Integer> caseFolded = new ArrayList<Integer>();
        for (int codepoint : codepoints) {
            if (RubyCaseFoldingData.CASE_FOLD.containsKey(codepoint)) {
                for (int caseFoldedCodepoint : (int[])RubyCaseFoldingData.CASE_FOLD.get(codepoint)) {
                    caseFolded.add(caseFoldedCodepoint);
                }
                continue;
            }
            caseFolded.add(codepoint);
        }
        return caseFolded;
    }

    private static void addChar(RegexASTBuilder astBuilder, int codepoint) {
        astBuilder.addCharClass(CodePointSet.create(codepoint), true);
    }

    private static void addString(RegexASTBuilder astBuilder, List<Integer> codepoints) {
        for (int codepoint : codepoints) {
            RubyCaseFolding.addChar(astBuilder, codepoint);
        }
    }

    private static void unfoldSegment(RegexASTBuilder astBuilder, List<Integer> caseFolded, List<RubyCaseUnfoldingTrie.Unfolding> unfoldings, int start, int end, int backtrackingDepth, boolean dropAsciiOnStart) {
        int unfoldingsNextIndex;
        if (backtrackingDepth > 8) {
            throw new UnsupportedRegexException("case-unfolding of case-insensitive string is too complex");
        }
        if (start == end) {
            return;
        }
        if (unfoldings.isEmpty()) {
            RubyCaseFolding.addString(astBuilder, caseFolded.subList(start, end));
            return;
        }
        RubyCaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(0);
        if (unfolding.getStart() > start) {
            RubyCaseFolding.addString(astBuilder, caseFolded.subList(start, unfolding.getStart()));
            RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings, unfolding.getStart(), end, backtrackingDepth, dropAsciiOnStart);
            return;
        }
        if (unfolding.getLength() > 1) {
            int unfoldingsNextIndex2;
            for (unfoldingsNextIndex2 = 1; unfoldingsNextIndex2 < unfoldings.size() && unfoldings.get(unfoldingsNextIndex2).getStart() < unfolding.getEnd(); ++unfoldingsNextIndex2) {
            }
            astBuilder.pushGroup();
            RubyCaseFolding.addChar(astBuilder, unfolding.getCodepoint());
            RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsNextIndex2, unfoldings.size()), unfolding.getEnd(), end, backtrackingDepth + 1, dropAsciiOnStart);
            astBuilder.nextSequence();
            RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(1, unfoldings.size()), start, end, backtrackingDepth + 1, dropAsciiOnStart);
            astBuilder.popGroup();
            return;
        }
        CodePointSetAccumulator acc = new CodePointSetAccumulator();
        if (!dropAsciiOnStart || start != 0 || !RubyRegexParser.isAscii(caseFolded.get(start))) {
            acc.addCodePoint(caseFolded.get(start));
        }
        for (unfoldingsNextIndex = 0; unfoldingsNextIndex < unfoldings.size() && unfoldings.get(unfoldingsNextIndex).getStart() == start; ++unfoldingsNextIndex) {
            assert (unfoldings.get(unfoldingsNextIndex).getLength() == 1);
            int codepoint = unfoldings.get(unfoldingsNextIndex).getCodepoint();
            if (dropAsciiOnStart && start == 0 && RubyRegexParser.isAscii(codepoint)) continue;
            acc.addCodePoint(codepoint);
        }
        astBuilder.addCharClass(acc.toCodePointSet());
        RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsNextIndex, unfoldings.size()), start + 1, end, backtrackingDepth, dropAsciiOnStart);
    }
}

