/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugValue;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.RemoteObject;

public final class RemoteObjectsHandler {
    private final Map<String, RemoteObject> remotesByIDs = new HashMap<String, RemoteObject>(100);
    private final Map<DebugValue, RemoteObject> remotesByValue = new IdentityHashMap<DebugValue, RemoteObject>(100);
    private final Map<String, DebugValue> customPreviewBodies = new HashMap<String, DebugValue>();
    private final Map<String, DebugValue> customPreviewConfigs = new HashMap<String, DebugValue>();
    private final Map<String, Set<String>> objectGroups = new HashMap<String, Set<String>>();
    private final InspectorExecutionContext context;

    RemoteObjectsHandler(InspectorExecutionContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteObject getRemote(DebugValue value) {
        RemoteObject remote;
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            remote = this.remotesByValue.get(value);
            if (remote == null) {
                remote = new RemoteObject(value, false, this.context);
                this.remotesByValue.put(value, remote);
                if (remote.getId() != null) {
                    this.remotesByIDs.put(remote.getId(), remote);
                }
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteObject getRemote(String objectId) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            return this.remotesByIDs.get(objectId);
        }
    }

    void register(RemoteObject remote) {
        this.register(remote, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(RemoteObject remote, String objectGroup) {
        if (remote.getId() != null) {
            Map<String, RemoteObject> map = this.remotesByIDs;
            synchronized (map) {
                this.remotesByIDs.put(remote.getId(), remote);
                if (objectGroup != null) {
                    Set<String> group = this.objectGroups.get(objectGroup);
                    if (group == null) {
                        group = new HashSet<String>();
                        this.objectGroups.put(objectGroup, group);
                    }
                    group.add(remote.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getObjectGroupOf(String objectId) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            for (Map.Entry<String, Set<String>> groupEntry : this.objectGroups.entrySet()) {
                if (!groupEntry.getValue().contains(objectId)) continue;
                return groupEntry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseObject(String objectId) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.remotesByIDs.remove(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseObjectGroup(String objectGroup) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            Set<String> group = this.objectGroups.remove(objectGroup);
            if (group != null) {
                for (String objectId : group) {
                    this.remotesByIDs.remove(objectId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRegisteredIDs() {
        HashSet<String> ids = new HashSet<String>();
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            ids.addAll(this.remotesByIDs.keySet());
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.remotesByValue.clear();
            this.customPreviewBodies.clear();
            this.customPreviewConfigs.clear();
            if (this.objectGroups.isEmpty()) {
                this.remotesByIDs.clear();
            } else {
                Set<Object> grouppedIds;
                if (this.objectGroups.size() == 1) {
                    grouppedIds = this.objectGroups.values().iterator().next();
                } else {
                    grouppedIds = new HashSet();
                    for (Set<String> group : this.objectGroups.values()) {
                        grouppedIds.addAll(group);
                    }
                }
                this.remotesByIDs.keySet().retainAll(grouppedIds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomPreviewBody(String id, DebugValue body) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.customPreviewBodies.put(id, body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugValue getCustomPreviewBody(String id) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            return this.customPreviewBodies.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomPreviewConfig(String objectId, DebugValue config) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.customPreviewConfigs.put(objectId, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugValue getCustomPreviewConfig(String id) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            return this.customPreviewConfigs.get(id);
        }
    }
}

