/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.MaterializedFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.EventBinding;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.EventContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Instrumenter;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.StandardTags;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.TruffleInstrument;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.NodeLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnknownIdentifierException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.LanguageInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection;

public final class TypeHandler {
    static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();
    private final TruffleInstrument.Env env;
    private final AtomicReference<EventBinding<TypeProfileEventFactory>> currentBinding;

    public TypeHandler(TruffleInstrument.Env env) {
        this.env = env;
        this.currentBinding = new AtomicReference();
    }

    public boolean isStarted() {
        return this.currentBinding.get() != null;
    }

    public boolean start(boolean inspectInternal) {
        if (this.currentBinding.get() == null) {
            SourceSectionFilter filter = SourceSectionFilter.newBuilder().tagIs(StandardTags.RootTag.class).includeInternal(inspectInternal).build();
            Instrumenter instrumenter = this.env.getInstrumenter();
            EventBinding<TypeProfileEventFactory> binding = instrumenter.attachExecutionEventFactory(filter, new TypeProfileEventFactory());
            if (this.currentBinding.compareAndSet(null, binding)) {
                return true;
            }
            binding.dispose();
        }
        return false;
    }

    public void stop() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        if (binding != null && this.currentBinding.compareAndSet(binding, null)) {
            binding.dispose();
        }
    }

    public void clearData() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        if (binding != null) {
            binding.getElement().profileMap.clear();
        }
    }

    public Collection<SectionTypeProfile> getSectionTypeProfiles() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        ArrayList<SectionTypeProfile> profiles = new ArrayList<SectionTypeProfile>(binding.getElement().profileMap.values());
        profiles.sort((p1, p2) -> Integer.compare(p1.sourceSection.getCharEndIndex(), p2.sourceSection.getCharEndIndex()));
        return profiles;
    }

    static String getMetaObjectString(TruffleInstrument.Env env, LanguageInfo language, Object argument) {
        Object view = env.getLanguageView(language, argument);
        InteropLibrary viewLib = InteropLibrary.getFactory().getUncached(view);
        String retType = null;
        if (viewLib.hasMetaObject(view)) {
            try {
                retType = INTEROP.asString(INTEROP.getMetaQualifiedName(viewLib.getMetaObject(view)));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        }
        return retType;
    }

    private final class TypeProfileEventFactory
    implements ExecutionEventNodeFactory {
        private final Map<SourceSection, SectionTypeProfile> profileMap = new ConcurrentHashMap<SourceSection, SectionTypeProfile>();

        private TypeProfileEventFactory() {
        }

        @Override
        public ExecutionEventNode create(final EventContext context) {
            return new ExecutionEventNode(){
                private final Node node;
                @Node.Child
                private NodeLibrary nodeLibrary;
                {
                    this.node = context.getInstrumentedNode();
                    this.nodeLibrary = NodeLibrary.getFactory().create(this.node);
                }

                @Override
                protected void onEnter(VirtualFrame frame) {
                    if (this.nodeLibrary.hasScope(this.node, frame)) {
                        this.onEnterSlowPath(frame.materialize());
                    }
                }

                @Override
                protected void onReturnValue(VirtualFrame frame, Object result) {
                    this.processReturnValue(result);
                }

                @CompilerDirectives.TruffleBoundary
                private void onEnterSlowPath(MaterializedFrame frame) {
                    try {
                        Object scope = this.nodeLibrary.getScope(this.node, frame, true);
                        this.processArguments(scope);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                }

                private void processArguments(Object arguments) {
                    SourceSection section = context.getInstrumentedSourceSection();
                    LanguageInfo language = this.node.getRootNode().getLanguageInfo();
                    try {
                        Object keys = INTEROP.getMembers(arguments);
                        long size = INTEROP.getArraySize(keys);
                        for (long i = 0L; i < size; ++i) {
                            Object argument = INTEROP.readArrayElement(keys, i);
                            String key = INTEROP.asString(argument);
                            Object argumentValue = INTEROP.readMember(arguments, key);
                            String retType = TypeHandler.getMetaObjectString(TypeHandler.this.env, language, argumentValue);
                            SourceSection argSection = TypeProfileEventFactory.this.getArgSection(section, argument);
                            if (argSection == null) continue;
                            TypeProfileEventFactory.this.profileMap.computeIfAbsent((SourceSection)argSection, (Function<SourceSection, SectionTypeProfile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processArguments$0(kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection ), (Lkasuga/lib/vendor_modules/com/oracle/truffle/api/source/SourceSection;)Lkasuga/lib/vendor_modules/com/oracle/truffle/tools/chromeinspector/TypeHandler$SectionTypeProfile;)()).types.add(retType);
                        }
                    }
                    catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                }

                @CompilerDirectives.TruffleBoundary
                private void processReturnValue(Object result) {
                    if (result != null) {
                        SourceSection section = context.getInstrumentedSourceSection();
                        LanguageInfo language = this.node.getRootNode().getLanguageInfo();
                        String retType = TypeHandler.getMetaObjectString(TypeHandler.this.env, language, result);
                        TypeProfileEventFactory.this.profileMap.computeIfAbsent((SourceSection)section, (Function<SourceSection, SectionTypeProfile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processReturnValue$1(kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection ), (Lkasuga/lib/vendor_modules/com/oracle/truffle/api/source/SourceSection;)Lkasuga/lib/vendor_modules/com/oracle/truffle/tools/chromeinspector/TypeHandler$SectionTypeProfile;)()).types.add(retType);
                    }
                }

                private static /* synthetic */ SectionTypeProfile lambda$processReturnValue$1(SourceSection s) {
                    return new SectionTypeProfile(s);
                }

                private static /* synthetic */ SectionTypeProfile lambda$processArguments$0(SourceSection s) {
                    return new SectionTypeProfile(s);
                }
            };
        }

        @CompilerDirectives.TruffleBoundary
        private SourceSection getArgSection(SourceSection function, Object argument) {
            try {
                if (INTEROP.hasSourceLocation(argument)) {
                    return INTEROP.getSourceLocation(argument);
                }
                String argName = INTEROP.asString(INTEROP.toDisplayString(argument));
                int idx = function.getCharacters().toString().indexOf(argName);
                return idx < 0 ? null : function.getSource().createSection(function.getCharIndex() + idx, argName.length());
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
    }

    public static interface Provider {
        public TypeHandler getTypeHandler();
    }

    public static final class SectionTypeProfile {
        private final SourceSection sourceSection;
        private final Collection<String> types = new HashSet<String>();

        private SectionTypeProfile(SourceSection sourceSection) {
            this.sourceSection = sourceSection;
        }

        public SourceSection getSourceSection() {
            return this.sourceSection;
        }

        public Collection<String> getTypes() {
            return this.types;
        }
    }
}

