/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.ArityException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.TruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnknownIdentifierException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedTypeException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
abstract class AbstractInspectorObject
implements TruffleObject {
    protected AbstractInspectorObject() {
    }

    @ExportMessage
    protected abstract Object getMembers(boolean var1);

    protected abstract boolean isField(String var1);

    protected abstract boolean isMethod(String var1);

    protected abstract Object getFieldValueOrNull(String var1);

    @ExportMessage
    protected abstract Object invokeMember(String var1, Object[] var2) throws UnsupportedTypeException, UnknownIdentifierException, ArityException, UnsupportedMessageException;

    @ExportMessage
    final boolean hasMembers() {
        return true;
    }

    @ExportMessage
    final boolean isMemberReadable(String member) {
        return this.isMethod(member) || this.isField(member);
    }

    @ExportMessage
    final boolean isMemberInvocable(String member) {
        return this.isMethod(member);
    }

    @ExportMessage
    protected final Object readMember(String name) throws UnknownIdentifierException {
        Object value = this.getFieldValueOrNull(name);
        if (value == null) {
            value = this.getMethodExecutable(name);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    final TruffleObject getMethodExecutable(String name) throws UnknownIdentifierException {
        if (this.isMethod(name)) {
            return this.createMethodExecutable(name);
        }
        throw UnknownIdentifierException.create(name);
    }

    @ExportMessage
    protected boolean isInstantiable() {
        return false;
    }

    @ExportMessage
    protected Object instantiate(Object[] arguments) throws UnsupportedMessageException {
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    private TruffleObject createMethodExecutable(String name) {
        CompilerAsserts.neverPartOfCompilation();
        return new MethodExecutable(this, name);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MethodExecutable
    implements TruffleObject {
        final AbstractInspectorObject inspector;
        private final String name;

        MethodExecutable(AbstractInspectorObject inspector, String name) {
            this.inspector = inspector;
            this.name = name;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @CachedLibrary(value="this.inspector") InteropLibrary interop) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            try {
                return interop.invokeMember(this.inspector, this.name, arguments);
            }
            catch (UnknownIdentifierException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError();
            }
        }
    }
}

