/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.TruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnknownIdentifierException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedTypeException;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.InspectorStateException;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.UndefinedProvider;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.server.InspectorServerConnection;

class Console
extends AbstractInspectorObject {
    private static final String METHOD_DEBUG = "debug";
    private static final String METHOD_ERROR = "error";
    private static final String METHOD_INFO = "info";
    private static final String METHOD_LOG = "log";
    private static final String METHOD_WARN = "warn";
    private static final String METHOD_DIR = "dir";
    private static final String METHOD_DIRXML = "dirxml";
    private static final String METHOD_TABLE = "table";
    private static final String METHOD_TRACE = "trace";
    private static final String METHOD_GROUP = "group";
    private static final String METHOD_GROUP_COLLAPSED = "groupCollapsed";
    private static final String METHOD_GROUP_END = "groupEnd";
    private static final String METHOD_CLEAR = "clear";
    private static final String METHOD_COUNT = "count";
    private static final String METHOD_COUNT_RESET = "countReset";
    private static final String METHOD_ASSERT = "assert";
    private static final String METHOD_MARK_TIMELINE = "markTimeline";
    private static final String METHOD_PROFILE = "profile";
    private static final String METHOD_PROFILE_END = "profileEnd";
    private static final String METHOD_TIMELINE = "timeline";
    private static final String METHOD_TIMELINE_END = "timelineEnd";
    private static final String METHOD_TIME = "time";
    private static final String METHOD_TIME_END = "timeEnd";
    private static final String METHOD_TIME_STAMP = "timeStamp";
    private static final String[] METHOD_NAMES = new String[]{"debug", "error", "info", "log", "warn", "dir", "dirxml", "table", "trace", "group", "groupCollapsed", "groupEnd", "clear", "count", "countReset", "assert", "markTimeline", "profile", "profileEnd", "timeline", "timelineEnd", "time", "timeEnd", "timeStamp"};
    private static final TruffleObject KEYS = new Keys();
    private static final Object UNKNOWN = new Object(){

        public String toString() {
            return "unknown";
        }
    };
    private InspectorServerConnection connection;
    private final UndefinedProvider undefinedProvider;
    private final Map<Object, Long> time = new ConcurrentHashMap<Object, Long>();

    Console(InspectorServerConnection connection, UndefinedProvider undefinedProvider) {
        this.connection = connection;
        this.undefinedProvider = undefinedProvider;
    }

    public static boolean isInstance(TruffleObject obj) {
        return obj instanceof Console;
    }

    void setConnection(InspectorServerConnection newConnection) {
        this.connection = newConnection;
    }

    @Override
    protected TruffleObject getMembers(boolean includeInternal) {
        return KEYS;
    }

    @Override
    protected boolean isField(String name) {
        return false;
    }

    @Override
    protected boolean isMethod(String name) {
        switch (name) {
            case "debug": 
            case "error": 
            case "info": 
            case "log": 
            case "warn": 
            case "dir": 
            case "dirxml": 
            case "table": 
            case "trace": 
            case "group": 
            case "groupCollapsed": 
            case "groupEnd": 
            case "clear": 
            case "count": 
            case "countReset": 
            case "assert": 
            case "markTimeline": 
            case "profile": 
            case "profileEnd": 
            case "timeline": 
            case "timelineEnd": 
            case "time": 
            case "timeEnd": 
            case "timeStamp": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object getFieldValueOrNull(String name) {
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object invokeMember(String name, Object[] arguments) throws UnsupportedTypeException, UnknownIdentifierException, UnsupportedMessageException {
        Object arg = arguments.length < 1 ? UNKNOWN : arguments[0];
        String type = name;
        switch (name) {
            case "debug": {
                break;
            }
            case "error": {
                break;
            }
            case "info": {
                break;
            }
            case "log": {
                break;
            }
            case "warn": {
                type = "warning";
                break;
            }
            case "dir": {
                break;
            }
            case "dirxml": {
                break;
            }
            case "table": {
                break;
            }
            case "trace": {
                break;
            }
            case "group": {
                type = "startGroup";
                break;
            }
            case "groupCollapsed": {
                type = "startGroupCollapsed";
                break;
            }
            case "groupEnd": {
                type = "endGroup";
                break;
            }
            case "clear": {
                break;
            }
            case "count": {
                break;
            }
            case "countReset": {
                break;
            }
            case "assert": {
                if (Console.isTrue(arguments[0])) {
                    return this.undefinedProvider.get();
                }
                if (arguments.length > 1) {
                    arg = arguments[1];
                    break;
                }
                arg = "console.assert";
                break;
            }
            case "markTimeline": {
                break;
            }
            case "profile": {
                break;
            }
            case "profileEnd": {
                break;
            }
            case "timeline": {
                break;
            }
            case "timelineEnd": {
                break;
            }
            case "time": {
                this.time.put(arg, System.nanoTime());
                return this.undefinedProvider.get();
            }
            case "timeEnd": {
                long t2 = System.nanoTime();
                Long t1 = this.time.remove(arg);
                String timer = arg.toString();
                if (t1 == null) {
                    arg = "Timer '" + timer + "' does not exist";
                    type = "warning";
                    break;
                }
                StringBuilder ts = new StringBuilder(timer);
                ts.append(": ");
                ts.append(Long.toString(t2 - t1));
                ts.insert(ts.length() - 6, '.');
                while (ts.charAt(ts.length() - 1) == '0') {
                    ts.deleteCharAt(ts.length() - 1);
                }
                ts.append("ms");
                arg = ts.toString();
                break;
            }
            case "timeStamp": {
                break;
            }
            default: {
                throw UnknownIdentifierException.create(name);
            }
        }
        if (this.connection == null) {
            throw new InspectorStateException("The inspector is not connected.");
        }
        this.connection.consoleAPICall(type, arg);
        return this.undefinedProvider.get();
    }

    private static boolean isTrue(Object obj) throws UnsupportedMessageException {
        InteropLibrary interop = InteropLibrary.getFactory().getUncached();
        if (interop.isBoolean(obj)) {
            return interop.asBoolean(obj);
        }
        return !interop.isNull(obj);
    }

    static final class Keys
    extends AbstractInspectorArray {
        Keys() {
        }

        @Override
        int getArraySize() {
            return METHOD_NAMES.length;
        }

        @Override
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index < 0L || index >= (long)METHOD_NAMES.length) {
                CompilerDirectives.transferToInterpreter();
                throw InvalidArrayIndexException.create(index);
            }
            return METHOD_NAMES[(int)index];
        }
    }
}

