/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import java.util.ArrayList;
import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.RuntimeCallFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

public final class ProfileNode {
    private final int id;
    private final RuntimeCallFrame callFrame;
    private final long hitCount;
    private final List<Integer> children;

    public ProfileNode(int id, RuntimeCallFrame callFrame, long hitCount) {
        this.id = id;
        this.callFrame = callFrame;
        this.hitCount = hitCount;
        this.children = new ArrayList<Integer>();
    }

    public int getId() {
        return this.id;
    }

    public RuntimeCallFrame getCallFrame() {
        return this.callFrame;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public void addChild(int childId) {
        this.children.add(childId);
    }

    private JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("id", this.id);
        json.put("callFrame", this.callFrame.toJSON());
        json.put("hitCount", this.hitCount);
        JSONArray array = new JSONArray();
        this.children.forEach(i -> array.put((int)i));
        json.put("children", array);
        return json;
    }

    static JSONArray toJSON(ProfileNode[] nodes) {
        JSONArray array = new JSONArray();
        for (ProfileNode node : nodes) {
            array.put(node.toJSON());
        }
        return array;
    }
}

