/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugScope;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.Location;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

public final class Scope {
    private final String type;
    private final RemoteObject object;
    private final String name;
    private final Location startLocation;
    private final Location endLocation;
    private final int internalIndex;

    public Scope(String type, RemoteObject object, String name, Location startLocation, Location endLocation, int internalIndex) {
        this.type = type;
        this.object = object;
        this.name = name;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.internalIndex = internalIndex;
    }

    public String getType() {
        return this.type;
    }

    public RemoteObject getObject() {
        return this.object;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public Location getEndLocation() {
        return this.endLocation;
    }

    public int getInternalIndex() {
        return this.internalIndex;
    }

    private JSONObject createJSON() {
        JSONObject json = new JSONObject();
        json.put("type", this.type);
        json.put("object", this.object.toJSON());
        json.putOpt("name", this.name);
        if (this.startLocation != null) {
            json.put("startLocation", this.startLocation.toJSON());
        }
        if (this.endLocation != null) {
            json.put("endLocation", this.endLocation.toJSON());
        }
        return json;
    }

    static JSONArray createScopesJSON(Scope[] scopes) {
        JSONArray array = new JSONArray();
        for (Scope scope : scopes) {
            DebugScope dscope = scope.object.getScope();
            if (!dscope.isFunctionScope() && !dscope.getDeclaredValues().iterator().hasNext()) continue;
            array.put(scope.createJSON());
        }
        return array;
    }
}

