/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import java.text.MessageFormat;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.Source;

public final class Script {
    private final int id;
    private final String url;
    private final Source source;
    private final Source sourceLoaded;

    public Script(int id, String url, Source source) {
        this(id, url, source, source);
    }

    public Script(int id, String url, Source source, Source sourceLoaded) {
        this.id = id;
        this.url = url;
        this.source = source;
        this.sourceLoaded = sourceLoaded;
    }

    public int getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public Source getSource() {
        return this.source;
    }

    public Source getSourceLoaded() {
        return this.sourceLoaded;
    }

    public CharSequence getCharacters() {
        if (this.source.hasCharacters()) {
            return this.source.getCharacters();
        }
        return MessageFormat.format("Can not load source from {0}\nPlease use the --inspect.SourcePath option to point to the source locations.\nExample: --inspect.SourcePath=/home/joe/project/src\n", this.source.getURI().toString());
    }

    public String getHash() {
        int i;
        CharSequence code = this.getCharacters();
        long[] p = new long[]{-659004675L, -649004673L, -349004687L, -149004693L, -89004677L};
        long[] random = new long[]{2784526796L, 1677719591L, 2506683595L, 439235352L, 720632785L};
        int[] randomOdd = new int[]{924047419, 419642053, -397998979, -840316385, 93057035};
        int numHashes = 5;
        long[] hashes = new long[numHashes];
        long[] zi = new long[]{1L, 1L, 1L, 1L, 1L};
        int current = 0;
        int l4 = code.length() / 4;
        for (i = 0; i < l4; i += 4) {
            char v = code.charAt(i);
            long xi = v * randomOdd[current] & Integer.MAX_VALUE;
            hashes[current] = (hashes[current] + zi[current] * xi) % p[current];
            zi[current] = zi[current] * random[current] % p[current];
            current = current == numHashes - 1 ? 0 : current + 1;
        }
        if (code.length() % 4 != 0) {
            int v = 0;
            for (int i2 = l4; i2 < code.length(); ++i2) {
                v <<= 8;
                v |= code.charAt(i2);
            }
            long xi = v * randomOdd[current] & Integer.MAX_VALUE;
            hashes[current] = (hashes[current] + zi[current] * xi) % p[current];
            zi[current] = zi[current] * random[current] % p[current];
        }
        for (i = 0; i < numHashes; ++i) {
            hashes[i] = (hashes[i] + zi[i] * (p[i] - 1L)) % p[i];
        }
        StringBuilder hash = new StringBuilder();
        for (int i3 = 0; i3 < numHashes; ++i3) {
            hash.append(Integer.toHexString((int)hashes[i3]));
        }
        return hash.toString();
    }
}

