/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugStackTraceElement;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.Source;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

public final class StackTrace {
    private final JSONObject jsonObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTrace(InspectorExecutionContext context, List<List<DebugStackTraceElement>> stacks) {
        JSONObject jsonStack = this.jsonObject = new JSONObject();
        JSONObject jsonParentStack = null;
        for (List<DebugStackTraceElement> frames : stacks) {
            if (jsonParentStack != null) {
                jsonStack.put("parent", jsonParentStack);
                jsonStack = jsonParentStack;
            }
            JSONArray callFrames = new JSONArray();
            for (DebugStackTraceElement frame : frames) {
                SourceSection sourceSection = frame.getSourceSection();
                if (sourceSection == null || !context.isInspectInternal() && frame.isInternal()) continue;
                Source source = sourceSection.getSource();
                if (!context.isInspectInternal() && source.isInternal()) continue;
                JSONObject callFrame = new JSONObject();
                callFrame.put("functionName", frame.getName());
                ScriptsHandler sch = context.acquireScriptsHandler();
                try {
                    int scriptId = sch.assureLoaded(source).getId();
                    callFrame.put("scriptId", Integer.toString(scriptId));
                    callFrame.put("url", sch.getScript(scriptId).getUrl());
                    callFrame.put("lineNumber", sourceSection.getStartLine() - 1);
                    callFrame.put("columnNumber", sourceSection.getStartColumn() - 1);
                    callFrames.put(callFrame);
                }
                finally {
                    context.releaseScriptsHandler();
                }
            }
            jsonStack.put("callFrames", callFrames);
            jsonParentStack = new JSONObject();
        }
    }

    public JSONObject toJSON() {
        return this.jsonObject;
    }
}

