/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl;

import java.lang.reflect.Method;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.TruffleInstrument;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.CPUSampler;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.CPUSamplerCLI;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.CPUSamplerCLIOptionDescriptors;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionDescriptors;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionValues;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Engine;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="cpusampler", name="CPU Sampler", version="0.5.0", services={CPUSampler.class}, website="https://www.graalvm.org/tools/profiling/")
public class CPUSamplerInstrument
extends TruffleInstrument {
    public static final String ID = "cpusampler";
    static final String VERSION = "0.5.0";
    private CPUSampler sampler;
    private static final ProfilerToolFactory<CPUSampler> factory = CPUSamplerInstrument.getDefaultFactory();

    private static ProfilerToolFactory<CPUSampler> getDefaultFactory() {
        try {
            Method createFactory = CPUSampler.class.getDeclaredMethod("createFactory", new Class[0]);
            createFactory.setAccessible(true);
            return (ProfilerToolFactory)createFactory.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static CPUSampler getSampler(Engine engine) {
        Instrument instrument = engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Sampler is not installed.");
        }
        return instrument.lookup(CPUSampler.class);
    }

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        this.sampler = factory.create(env);
        OptionValues options = env.getOptions();
        CPUSamplerCLI.EnableOptionData enableOptionData = options.get(CPUSamplerCLI.ENABLED);
        if (enableOptionData.enabled) {
            this.sampler.setPeriod(options.get(CPUSamplerCLI.SAMPLE_PERIOD));
            this.sampler.setDelay(options.get(CPUSamplerCLI.DELAY_PERIOD));
            this.sampler.setStackLimit(options.get(CPUSamplerCLI.STACK_LIMIT));
            this.sampler.setFilter(CPUSamplerInstrument.getSourceSectionFilter(env));
            this.sampler.setGatherSelfHitTimes(options.get(CPUSamplerCLI.GATHER_HIT_TIMES));
            this.sampler.setSampleContextInitialization(options.get(CPUSamplerCLI.SAMPLE_CONTEXT_INITIALIZATION));
            this.sampler.setCollecting(true);
        }
        env.registerService(this.sampler);
    }

    private static SourceSectionFilter getSourceSectionFilter(TruffleInstrument.Env env) {
        boolean internals = env.getOptions().get(CPUSamplerCLI.SAMPLE_INTERNAL);
        WildcardFilter filterRootName = env.getOptions().get(CPUSamplerCLI.FILTER_ROOT);
        WildcardFilter filterFile = env.getOptions().get(CPUSamplerCLI.FILTER_FILE);
        String filterMimeType = env.getOptions().get(CPUSamplerCLI.FILTER_MIME_TYPE);
        String filterLanguage = env.getOptions().get(CPUSamplerCLI.FILTER_LANGUAGE);
        return CPUSamplerCLI.buildFilter(true, false, false, internals, filterRootName, filterFile, filterMimeType, filterLanguage);
    }

    @Override
    protected OptionDescriptors getOptionDescriptors() {
        return new CPUSamplerCLIOptionDescriptors();
    }

    @Override
    protected void onDispose(TruffleInstrument.Env env) {
        OptionValues options = env.getOptions();
        CPUSamplerCLI.EnableOptionData enableOptionData = options.get(CPUSamplerCLI.ENABLED);
        if (enableOptionData.enabled) {
            CPUSamplerCLI.handleOutput(env, this.sampler);
        }
        this.sampler.close();
    }
}

