/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl;

import java.lang.reflect.Method;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.Option;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.TruffleInstrument;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.HeapMonitor;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.HeapMonitorInstrumentOptionDescriptors;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionCategory;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionDescriptors;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionKey;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Engine;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="heapmonitor", name="Heap Allocation Monitor", version="0.1.0", services={HeapMonitor.class})
public class HeapMonitorInstrument
extends TruffleInstrument {
    public static final String ID = "heapmonitor";
    static final String VERSION = "0.1.0";
    private HeapMonitor monitor;
    private static final ProfilerToolFactory<HeapMonitor> factory = HeapMonitorInstrument.getDefaultFactory();
    @Option(name="", help="Start the heap allocation monitor with the application. This produces no output but improves the precision of the data provided to third party tools.", category=OptionCategory.USER)
    static final OptionKey<Boolean> ENABLED = new OptionKey<Boolean>(false);

    private static ProfilerToolFactory<HeapMonitor> getDefaultFactory() {
        try {
            Method createFactory = HeapMonitor.class.getDeclaredMethod("createFactory", new Class[0]);
            createFactory.setAccessible(true);
            return (ProfilerToolFactory)createFactory.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static HeapMonitor getMonitor(Engine engine) {
        Instrument instrument = engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Heap Monitor is not installed.");
        }
        return instrument.lookup(HeapMonitor.class);
    }

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        this.monitor = factory.create(env);
        if (env.getOptions().get(ENABLED).booleanValue()) {
            this.monitor.setCollecting(true);
        }
        env.registerService(this.monitor);
    }

    @Override
    protected OptionDescriptors getOptionDescriptors() {
        return new HeapMonitorInstrumentOptionDescriptors();
    }

    @Override
    protected void onDispose(TruffleInstrument.Env env) {
        this.monitor.close();
    }
}

