/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.TruffleInstrument;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.MemoryTracer;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.MemoryTracerCLI;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.MemoryTracerCLIOptionDescriptors;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionDescriptors;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Engine;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="memtracer", name="Memory Tracer", version="0.2", services={MemoryTracer.class}, website="https://www.graalvm.org/tools/profiling/")
public class MemoryTracerInstrument
extends TruffleInstrument {
    public static final String ID = "memtracer";
    private MemoryTracer tracer;
    private static ProfilerToolFactory<MemoryTracer> factory;

    public static void setFactory(ProfilerToolFactory<MemoryTracer> factory) {
        if (factory == null || !factory.getClass().getName().startsWith("kasuga.lib.vendor_modules.com.oracle.truffle.tools.profiler")) {
            throw new IllegalArgumentException("Wrong factory: " + factory);
        }
        MemoryTracerInstrument.factory = factory;
    }

    public static MemoryTracer getTracer(Engine engine) {
        Instrument instrument = engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Memory Tracer is not installed.");
        }
        return instrument.lookup(MemoryTracer.class);
    }

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        this.tracer = factory.create(env);
        if (env.getOptions().get(MemoryTracerCLI.ENABLED).booleanValue()) {
            this.tracer.setFilter(MemoryTracerInstrument.getSourceSectionFilter(env));
            this.tracer.setStackLimit(env.getOptions().get(MemoryTracerCLI.STACK_LIMIT));
            this.tracer.setCollecting(true);
        }
        env.registerService(this.tracer);
    }

    private static SourceSectionFilter getSourceSectionFilter(TruffleInstrument.Env env) {
        boolean roots = env.getOptions().get(MemoryTracerCLI.TRACE_ROOTS);
        boolean statements = env.getOptions().get(MemoryTracerCLI.TRACE_STATEMENTS);
        boolean calls = env.getOptions().get(MemoryTracerCLI.TRACE_CALLS);
        boolean internals = env.getOptions().get(MemoryTracerCLI.TRACE_INTERNAL);
        WildcardFilter filterRootName = env.getOptions().get(MemoryTracerCLI.FILTER_ROOT);
        WildcardFilter filterFile = env.getOptions().get(MemoryTracerCLI.FILTER_FILE);
        String filterMimeType = env.getOptions().get(MemoryTracerCLI.FILTER_MIME_TYPE);
        String filterLanguage = env.getOptions().get(MemoryTracerCLI.FILTER_LANGUAGE);
        return MemoryTracerCLI.buildFilter(roots, statements, calls, internals, filterRootName, filterFile, filterMimeType, filterLanguage);
    }

    @Override
    protected OptionDescriptors getOptionDescriptors() {
        return new MemoryTracerCLIOptionDescriptors();
    }

    @Override
    protected void onDispose(TruffleInstrument.Env env) {
        if (env.getOptions().get(MemoryTracerCLI.ENABLED).booleanValue()) {
            MemoryTracerCLI.handleOutput(env, this.tracer);
        }
        this.tracer.close();
    }

    static {
        try {
            Class.forName(MemoryTracer.class.getName(), true, MemoryTracer.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new AssertionError();
        }
    }
}

