/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.logic.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kasuga.lib.vendor_modules.interpreter.Utils;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalBool;
import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalNumeric;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalAssignable;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalOperator;
import kasuga.lib.vendor_modules.interpreter.logic.operations.BoolOperation;
import kasuga.lib.vendor_modules.interpreter.logic.operations.BoolType;
import kasuga.lib.vendor_modules.interpreter.logic.operations.MathOperation;
import kasuga.lib.vendor_modules.interpreter.logic.operations.MathType;

public class LogicalLine
implements LogicalData,
LogicalAssignable {
    private final ArrayList<LogicalData> elements;
    private final String context = "CONTEXT";
    private final Namespace namespace;

    public LogicalLine(Namespace namespace) {
        this.elements = new ArrayList();
        this.namespace = namespace;
    }

    public LogicalLine(ArrayList<LogicalData> elements, Namespace namespace) {
        this.elements = elements;
        this.namespace = namespace;
    }

    public LogicalLine(String string, Namespace namespace) {
        this(namespace);
        this.fromString(string);
    }

    public void fromString(String string) {
        string = ((String)string).trim();
        int length = 0;
        while (length != ((String)string).length()) {
            length = ((String)string).length();
            string = ((String)string).replace("  ", " ");
        }
        HashMap<String, LogicalData> inner = new HashMap<String, LogicalData>();
        ArrayList<Integer> patternIndex = new ArrayList<Integer>();
        ArrayList<String> patternString = new ArrayList<String>();
        if (Utils.containsBrackets((String)string)) {
            if (!Utils.checkBrackets((String)string)) {
                throw new RuntimeException();
            }
            this.findPatterns((String)string, patternIndex, patternString);
            int[] brackets = Utils.positionBrackets((String)string);
            while (this.isValidBrackets(brackets)) {
                int former = -1;
                for (Integer index : patternIndex) {
                    if (index <= brackets[0] || index >= brackets[1]) continue;
                    former = index;
                    break;
                }
                if (former > -1) {
                    LogicalLine line;
                    LogicalData data = new LogicalLine(((String)string).substring(brackets[0] + 1, brackets[1]), this.namespace);
                    while (data instanceof LogicalLine && !(line = data).isEmpty() && line.isAtomic()) {
                        data = line.getFirst();
                    }
                    inner.put("CONTEXT" + inner.size(), data);
                    string = ((String)string).substring(0, brackets[0]) + "CONTEXT" + (inner.size() - 1) + ((String)string).substring(brackets[1] + 1);
                    if (!Utils.containsBrackets((String)string)) break;
                    this.findPatterns((String)string, patternIndex, patternString);
                    brackets = Utils.positionBrackets((String)string);
                    continue;
                }
                int ofst = brackets[1] + 1;
                String s = ((String)string).substring(brackets[1] + 1);
                if (!Utils.containsBrackets(s)) break;
                brackets = Utils.positionBrackets(s);
                if (!this.isValidBrackets(brackets)) continue;
                brackets[0] = brackets[0] + ofst;
                brackets[1] = brackets[1] + ofst;
            }
        }
        this.findPatterns((String)string, patternIndex, patternString);
        int offset = 0;
        int counter = 0;
        for (Integer index : patternIndex) {
            String pattern;
            String token = ((String)string).substring(offset, index).replace(" ", "");
            if (!token.equals("")) {
                this.loadToken(inner, token, this.namespace);
            }
            if (BoolOperation.isBoolOperation(pattern = patternString.get(counter))) {
                this.elements.add(new BoolOperation(pattern));
            } else {
                this.elements.add(new MathOperation(pattern));
            }
            offset = index + pattern.length();
            ++counter;
        }
        String token = ((String)string).substring(offset).trim();
        this.loadToken(inner, token, this.namespace);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (LogicalData data : this.elements) {
            if (data instanceof LogicalOperator) {
                builder.append(" ").append(data).append(" ");
                continue;
            }
            builder.append(data.toString());
        }
        return builder.toString();
    }

    private void loadToken(HashMap<String, LogicalData> inner, String token, Namespace namespace) {
        if (token.startsWith("CONTEXT")) {
            this.elements.add(inner.get(token));
        } else if (LogicalBool.isBool(token)) {
            this.elements.add(new LogicalBool(token));
        } else {
            LogicalNumeric numeric = new LogicalNumeric(token, namespace);
            this.elements.add(numeric);
        }
    }

    public void findPatterns(String string, ArrayList<Integer> integers, ArrayList<String> strings) {
        integers.clear();
        strings.clear();
        Matcher matcher = LogicalLine.matcher(string);
        while (matcher.find()) {
            if (integers.contains(matcher.start()) || matcher.start() > 0 && string.charAt(matcher.start() - 1) != ' ' || matcher.end() < string.length() && string.charAt(matcher.end()) != ' ') continue;
            integers.add(matcher.start());
            strings.add(matcher.group());
        }
    }

    private boolean isValidBrackets(int[] positions) {
        return positions[0] > -1 && positions[1] > -1;
    }

    public LogicalData getFirst() {
        return this.elements.get(0);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean isAtomic() {
        return this.elements.size() <= 1;
    }

    @Override
    public LogicalLine clone() {
        return new LogicalLine(new ArrayList<LogicalData>(this.elements), this.namespace.clone());
    }

    @Override
    public boolean getResult() {
        ArrayList<LogicalData> datas = new ArrayList<LogicalData>(this.elements);
        this.dealLeveledOperation(datas, new Object[]{MathType.EQUALS});
        this.dealLeveledOperation(datas, new Object[]{MathType.NOT_EQU});
        this.dealLeveledOperation(datas, new Object[]{MathType.LARGER, MathType.SMALLER});
        this.dealLeveledOperation(datas, new Object[]{MathType.LARGER_EQU, MathType.SMALLER_EQU});
        this.dealLeveledOperation(datas, new Object[]{BoolType.NOT});
        this.dealLeveledOperation(datas, new Object[]{BoolType.AND});
        this.dealLeveledOperation(datas, new Object[]{BoolType.OR});
        if (datas.size() == 1) {
            return datas.get(0).getResult();
        }
        return false;
    }

    private void dealLeveledOperation(ArrayList<LogicalData> datas, Object ... types) {
        ArrayList<Integer> locations = this.locateOperation(datas, types);
        int offset = 0;
        block0: for (Integer index : locations) {
            LogicalOperator operator = (LogicalOperator)((Object)datas.get(index - offset));
            for (Object type : types) {
                BoolType bool;
                if (!operator.is(type)) continue;
                if (!(type instanceof BoolType) && !(type instanceof MathType)) continue block0;
                if (type instanceof BoolType && (bool = (BoolType)((Object)type)) == BoolType.NOT) {
                    datas.set(index - offset, new LogicalBool(operator.operate(null, datas.get(index - offset + 1))));
                    datas.remove(index - offset + 1);
                    ++offset;
                    continue block0;
                }
                datas.set(index - offset - 1, new LogicalBool(operator.operate(datas.get(index - offset - 1), datas.get(index - offset + 1))));
                datas.remove(index - offset);
                datas.remove(index - offset);
                offset += 2;
                continue block0;
            }
        }
    }

    private ArrayList<Integer> locateOperation(ArrayList<LogicalData> datas, Object ... types) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        block0: for (int i = 0; i < datas.size(); ++i) {
            LogicalData data = datas.get(i);
            for (Object obj : types) {
                LogicalOperator operator;
                if (!(data instanceof LogicalOperator) || !(operator = (LogicalOperator)((Object)data)).is(obj)) continue;
                result.add(i);
                continue block0;
            }
        }
        return result;
    }

    public static Matcher matcher(String string) {
        Pattern pattern = Pattern.compile("(not)|(and)|(or)|(>=)|(<=)|(==)|(!=)|(<>)|(>)|(<)");
        return pattern.matcher(string);
    }

    @Override
    public boolean isAssignable() {
        return this.namespace.instanceVarSize() > 0;
    }

    @Override
    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogicalLine)) {
            return false;
        }
        LogicalLine line = (LogicalLine)obj;
        return this.toString().equals(line.toString());
    }
}

