/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.binding;

import com.caoccao.javet.annotations.V8Convert;
import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.enums.V8ProxyMode;
import com.caoccao.javet.interop.binding.IClassProxyPlugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClassDescriptor {
    protected final List<Method> applyFunctions = new ArrayList<Method>();
    protected final IClassProxyPlugin classProxyPlugin;
    protected final List<Constructor<?>> constructors = new ArrayList();
    protected final Map<String, Field> fieldMap = new LinkedHashMap<String, Field>();
    protected final List<Method> genericGetters = new ArrayList<Method>();
    protected final List<Method> genericSetters = new ArrayList<Method>();
    protected final Map<String, List<Method>> gettersMap = new LinkedHashMap<String, List<Method>>();
    protected final Map<String, List<Method>> methodsMap;
    protected final Map<String, List<Method>> settersMap;
    protected final Set<String> uniqueKeySet;
    protected V8ProxyMode proxyMode;
    protected Class<?> targetClass;

    public ClassDescriptor(V8ProxyMode proxyMode, Class<?> targetClass, IClassProxyPlugin classProxyPlugin) {
        this.classProxyPlugin = Objects.requireNonNull(classProxyPlugin);
        this.methodsMap = new LinkedHashMap<String, List<Method>>();
        this.proxyMode = proxyMode;
        this.settersMap = new LinkedHashMap<String, List<Method>>();
        this.targetClass = targetClass;
        this.uniqueKeySet = new LinkedHashSet<String>();
    }

    public List<Method> getApplyFunctions() {
        return this.applyFunctions;
    }

    public IClassProxyPlugin getClassProxyPlugin() {
        return this.classProxyPlugin;
    }

    public List<Constructor<?>> getConstructors() {
        return this.constructors;
    }

    public V8ConversionMode getConversionMode() {
        return this.getTargetClass().isAnnotationPresent(V8Convert.class) ? this.getTargetClass().getAnnotation(V8Convert.class).mode() : V8ConversionMode.Transparent;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public List<Method> getGenericGetters() {
        return this.genericGetters;
    }

    public List<Method> getGenericSetters() {
        return this.genericSetters;
    }

    public Map<String, List<Method>> getGettersMap() {
        return this.gettersMap;
    }

    public Map<String, List<Method>> getMethodsMap() {
        return this.methodsMap;
    }

    public V8ProxyMode getProxyMode() {
        return this.proxyMode;
    }

    public Map<String, List<Method>> getSettersMap() {
        return this.settersMap;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Set<String> getUniqueKeySet() {
        return this.uniqueKeySet;
    }
}

