/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.entities.JavetEntityPropertyDescriptor;
import com.caoccao.javet.enums.V8ValueSymbolType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetBiFunction;
import com.caoccao.javet.interfaces.IJavetEntityPropertyDescriptor;
import com.caoccao.javet.interfaces.IJavetEntitySymbol;
import com.caoccao.javet.interfaces.IJavetUniFunction;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.binding.IClassProxyPlugin;
import com.caoccao.javet.interop.binding.IClassProxyPluginFunction;
import com.caoccao.javet.interop.callback.IJavetDirectCallable;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.util.Map;
import java.util.Optional;

public interface IJavetDirectProxyHandler<E extends Exception> {
    default public V8Value createTargetObject() {
        return Optional.ofNullable(this.getProxyPlugin()).map(p -> p.getTargetObjectConstructor(this.getClass())).map(f -> {
            try {
                return f.invoke(this.getV8Runtime(), this);
            }
            catch (Throwable throwable) {
                return null;
            }
        }).orElse(null);
    }

    default public IClassProxyPlugin getProxyPlugin() {
        return null;
    }

    public V8Runtime getV8Runtime();

    default public V8Value proxyApply(V8Value target, V8Value thisObject, V8ValueArray arguments) throws JavetException, E {
        return null;
    }

    default public V8ValueBoolean proxyDeleteProperty(V8Value target, V8Value property) throws JavetException, E {
        boolean deleted = false;
        IClassProxyPlugin classProxyPlugin = this.getProxyPlugin();
        if (classProxyPlugin != null && classProxyPlugin.isDeleteSupported(this.getClass())) {
            deleted = classProxyPlugin.deleteByObject(this, this.getV8Runtime().toObject(property));
        }
        if (deleted) {
            return this.getV8Runtime().createV8ValueBoolean(true);
        }
        return null;
    }

    default public V8Value proxyGet(V8Value target, V8Value property, V8Value receiver) throws JavetException, E {
        String propertyString;
        V8Value v8Value = null;
        IClassProxyPlugin classProxyPlugin = this.getProxyPlugin();
        if (classProxyPlugin != null) {
            Object result;
            int index;
            if (classProxyPlugin.isIndexSupported(this.getClass()) && property instanceof V8ValueString && StringUtils.isDigital(propertyString = (String)((V8ValueString)property).getValue()) && (index = Integer.parseInt(propertyString)) >= 0 && (result = classProxyPlugin.getByIndex(this, index)) != null) {
                v8Value = this.getV8Runtime().toV8Value(result);
            }
            if (v8Value == null) {
                IClassProxyPluginFunction classProxyPluginFunction = null;
                if (property instanceof V8ValueString) {
                    String propertyName = (String)((V8ValueString)property).getValue();
                    classProxyPluginFunction = classProxyPlugin.getProxyGetByString(this.getClass(), propertyName);
                } else if (property instanceof V8ValueSymbol) {
                    V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
                    String description = propertySymbol.getDescription();
                    classProxyPluginFunction = classProxyPlugin.getProxyGetBySymbol(this.getClass(), description);
                }
                if (classProxyPluginFunction != null) {
                    v8Value = classProxyPluginFunction.invoke(this.getV8Runtime(), this);
                }
            }
        }
        if (v8Value == null && property instanceof V8ValueString) {
            propertyString = (String)((V8ValueString)property).getValue();
            Optional<IJavetUniFunction> optionalGetter = Optional.ofNullable(this.proxyGetStringGetterMap()).map(m -> (IJavetUniFunction)m.get(propertyString));
            if (optionalGetter.isPresent()) {
                v8Value = (V8Value)optionalGetter.get().apply(propertyString);
            } else if ("toJSON".equals(propertyString)) {
                v8Value = this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("toJSON", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::toJSON));
            } else if ("toV8Value".equals(propertyString)) {
                v8Value = this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("toV8Value", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::symbolToPrimitive));
            }
        } else if (v8Value == null && property instanceof V8ValueSymbol) {
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            Optional<IJavetUniFunction> optionalGetter = Optional.ofNullable(this.proxyGetSymbolGetterMap()).map(m -> (IJavetUniFunction)m.get(description));
            if (optionalGetter.isPresent()) {
                v8Value = (V8Value)optionalGetter.get().apply(propertySymbol);
            } else if ("Symbol.toPrimitive".equals(description)) {
                v8Value = this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("Symbol.toPrimitive", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::symbolToPrimitive));
            } else if ("Symbol.iterator".equals(description)) {
                v8Value = this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("Symbol.iterator", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::symbolIterator));
            }
        }
        return v8Value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public V8Value proxyGetOwnPropertyDescriptor(V8Value target, V8Value property) throws JavetException, E {
        V8Value v8Value = null;
        IJavetEntityPropertyDescriptor<V8Value> javetEntityPropertyDescriptor = null;
        try {
            if (property instanceof V8ValueString) {
                String propertyString = (String)((V8ValueString)property).getValue();
                Optional<IJavetUniFunction> optionalGetter = Optional.ofNullable(this.proxyGetStringGetterMap()).map(m -> (IJavetUniFunction)m.get(propertyString));
                if (optionalGetter.isPresent()) {
                    v8Value = (V8Value)optionalGetter.get().apply(propertyString);
                }
                if (v8Value == null) {
                    IClassProxyPlugin classProxyPlugin = this.getProxyPlugin();
                    if (classProxyPlugin != null) {
                        javetEntityPropertyDescriptor = classProxyPlugin.getProxyOwnPropertyDescriptor(this, propertyString);
                        javetEntityPropertyDescriptor.setValue(this.getV8Runtime().createV8ValueUndefined());
                    }
                } else {
                    javetEntityPropertyDescriptor = new JavetEntityPropertyDescriptor<V8Value>(true, true, true, v8Value);
                }
            } else if (property instanceof V8ValueSymbol) {
                V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
                String description = propertySymbol.getDescription();
                Optional<IJavetUniFunction> optionalGetter = Optional.ofNullable(this.proxyGetSymbolGetterMap()).map(m -> (IJavetUniFunction)m.get(description));
                if (optionalGetter.isPresent()) {
                    v8Value = (V8Value)optionalGetter.get().apply(propertySymbol);
                }
                if (v8Value != null) {
                    javetEntityPropertyDescriptor = new JavetEntityPropertyDescriptor<V8Value>(true, true, true, v8Value);
                }
            }
            if (javetEntityPropertyDescriptor != null) {
                Object v = this.getV8Runtime().toV8Value(javetEntityPropertyDescriptor);
                return v;
            }
        }
        finally {
            JavetResourceUtils.safeClose(v8Value);
        }
        return null;
    }

    default public V8Value proxyGetPrototypeOf(V8Value target) throws JavetException, E {
        return null;
    }

    default public Map<String, IJavetUniFunction<String, ? extends V8Value, E>> proxyGetStringGetterMap() {
        return null;
    }

    default public Map<String, IJavetBiFunction<String, V8Value, Boolean, E>> proxyGetStringSetterMap() {
        return null;
    }

    default public Map<String, IJavetUniFunction<V8ValueSymbol, ? extends V8Value, E>> proxyGetSymbolGetterMap() {
        return null;
    }

    default public Map<String, IJavetBiFunction<V8ValueSymbol, V8Value, Boolean, E>> proxyGetSymbolSetterMap() {
        return null;
    }

    default public V8ValueBoolean proxyHas(V8Value target, V8Value property) throws JavetException, E {
        boolean hasProperty = false;
        IClassProxyPlugin classProxyPlugin = this.getProxyPlugin();
        if (classProxyPlugin != null && classProxyPlugin.isHasSupported(this.getClass())) {
            hasProperty = classProxyPlugin.hasByObject(this, this.getV8Runtime().toObject(property));
        }
        if (!hasProperty && property instanceof V8ValueString) {
            String propertyString = ((V8ValueString)property).toPrimitive();
            Map<String, IJavetUniFunction<String, V8Value, E>> stringGetterMap = this.proxyGetStringGetterMap();
            if (stringGetterMap != null && !stringGetterMap.isEmpty()) {
                hasProperty = stringGetterMap.containsKey(propertyString);
            }
        } else if (!hasProperty && property instanceof V8ValueSymbol) {
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            Map<String, IJavetUniFunction<V8ValueSymbol, V8Value, E>> symbolGetterMap = this.proxyGetSymbolGetterMap();
            if (symbolGetterMap != null && !symbolGetterMap.isEmpty()) {
                hasProperty = symbolGetterMap.containsKey(description);
            }
        }
        if (hasProperty) {
            return this.getV8Runtime().createV8ValueBoolean(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public V8ValueArray proxyOwnKeys(V8Value target) throws JavetException, E {
        Object[] keys;
        block6: {
            V8ValueArray v8ValueArray;
            keys = null;
            try {
                IClassProxyPlugin classProxyPlugin;
                Map<String, IJavetUniFunction<String, V8Value, E>> stringGetterMap = this.proxyGetStringGetterMap();
                if (stringGetterMap != null && !stringGetterMap.isEmpty()) {
                    keys = new Object[stringGetterMap.size()];
                    int index = 0;
                    for (String string : stringGetterMap.keySet()) {
                        keys[index++] = this.getV8Runtime().createV8ValueString(string);
                    }
                }
                if (keys == null && (classProxyPlugin = this.getProxyPlugin()).isOwnKeysSupported(this.getClass())) {
                    keys = classProxyPlugin.getProxyOwnKeys(this);
                    for (int i = 0; i < keys.length; ++i) {
                        Object object = keys[i];
                        keys[i] = object instanceof String ? this.getV8Runtime().createV8ValueString((String)object) : (object instanceof IJavetEntitySymbol ? this.getV8Runtime().createV8ValueSymbol(((IJavetEntitySymbol)object).getDescription()) : this.getV8Runtime().createV8ValueString(String.valueOf(object)));
                    }
                }
                if (keys == null) break block6;
                v8ValueArray = V8ValueUtils.createV8ValueArray(this.getV8Runtime(), keys);
            }
            catch (Throwable throwable) {
                JavetResourceUtils.safeClose(keys);
                throw throwable;
            }
            JavetResourceUtils.safeClose(keys);
            return v8ValueArray;
        }
        JavetResourceUtils.safeClose(keys);
        return null;
    }

    default public V8ValueBoolean proxySet(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException, E {
        int index;
        String propertyKeyString;
        boolean isSet = false;
        IClassProxyPlugin classProxyPlugin = this.getProxyPlugin();
        if (classProxyPlugin != null && classProxyPlugin.isIndexSupported(this.getClass()) && propertyKey instanceof V8ValueString && StringUtils.isDigital(propertyKeyString = (String)((V8ValueString)propertyKey).getValue()) && (index = Integer.parseInt(propertyKeyString)) >= 0) {
            isSet = classProxyPlugin.setByIndex(this, index, this.getV8Runtime().toObject(propertyValue));
        }
        if (!isSet && propertyKey instanceof V8ValueString) {
            IJavetBiFunction<String, V8Value, Boolean, E> setter;
            propertyKeyString = ((V8ValueString)propertyKey).toPrimitive();
            Map<String, IJavetBiFunction<String, V8Value, Boolean, E>> stringSetterMap = this.proxyGetStringSetterMap();
            if (stringSetterMap != null && !stringSetterMap.isEmpty() && (setter = stringSetterMap.get(propertyKeyString)) != null) {
                isSet = setter.apply(propertyKeyString, propertyValue);
            }
        } else if (!isSet && propertyKey instanceof V8ValueSymbol) {
            IJavetBiFunction<V8ValueSymbol, V8Value, Boolean, E> setter;
            V8ValueSymbol propertyKeySymbol = (V8ValueSymbol)propertyKey;
            String description = propertyKeySymbol.getDescription();
            Map<String, IJavetBiFunction<V8ValueSymbol, V8Value, Boolean, E>> symbolSetterMap = this.proxyGetSymbolSetterMap();
            if (symbolSetterMap != null && !symbolSetterMap.isEmpty() && (setter = symbolSetterMap.get(description)) != null) {
                isSet = setter.apply(propertyKeySymbol, propertyValue);
            }
        }
        if (isSet) {
            return this.getV8Runtime().createV8ValueBoolean(true);
        }
        return null;
    }

    default public void registerStringGetter(String propertyName, IJavetUniFunction<String, ? extends V8Value, E> getter) {
        this.proxyGetStringGetterMap().put(propertyName, getter);
    }

    default public void registerStringGetterFunction(String propertyName, IJavetDirectCallable.NoThisAndResult<?> getter) {
        this.proxyGetStringGetterMap().put(propertyName, innerPropertyName -> this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext((String)innerPropertyName, JavetCallbackType.DirectCallNoThisAndResult, getter)));
    }

    default public void registerStringSetter(String propertyName, IJavetBiFunction<String, V8Value, Boolean, E> setter) {
        this.proxyGetStringSetterMap().put(propertyName, setter);
    }

    default public void registerSymbolGetterFunction(String propertyName, IJavetDirectCallable.NoThisAndResult<?> getter) {
        this.proxyGetSymbolGetterMap().put(propertyName, propertySymbol -> this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext(propertySymbol.getDescription(), JavetCallbackType.DirectCallNoThisAndResult, getter)));
    }

    default public void setV8Runtime(V8Runtime v8Runtime) {
    }

    default public V8Value symbolIterator(V8Value ... v8Values) throws JavetException, E {
        return this.getV8Runtime().createV8ValueUndefined();
    }

    default public V8Value symbolToPrimitive(V8Value ... v8Values) throws JavetException, E {
        return this.getV8Runtime().createV8ValueNull();
    }

    default public V8Value toJSON(V8Value ... v8Values) throws JavetException, E {
        return this.getV8Runtime().createV8ValueObject();
    }
}

