/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.proxy.BaseJavetReflectionProxyInvocationHandler;
import com.caoccao.javet.interop.proxy.JavetReflectionProxyV8ValueFunctionInvocationHandler;
import com.caoccao.javet.interop.proxy.JavetReflectionProxyV8ValueObjectInvocationHandler;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public final class JavetReflectionProxyFactory {
    private static final JavetReflectionProxyFactory instance = new JavetReflectionProxyFactory();

    private JavetReflectionProxyFactory() {
    }

    public static JavetReflectionProxyFactory getInstance() {
        return instance;
    }

    public boolean isSupportedFunction(Class<?> type, V8Value v8Value) {
        return type.isInterface() && v8Value instanceof V8ValueFunction;
    }

    public boolean isSupportedObject(Class<?> type, V8Value v8Value) {
        return type.isInterface() && v8Value instanceof V8ValueObject && !(v8Value instanceof V8ValueProxy) && !(v8Value instanceof V8ValueFunction);
    }

    public Object toObject(Class<?> type, V8Value v8Value) throws JavetException {
        if (type.isInterface()) {
            BaseJavetReflectionProxyInvocationHandler invocationHandler = null;
            if (v8Value instanceof V8ValueFunction) {
                invocationHandler = new JavetReflectionProxyV8ValueFunctionInvocationHandler((V8ValueFunction)v8Value.toClone());
            } else if (v8Value instanceof V8ValueObject && !(v8Value instanceof V8ValueProxy)) {
                invocationHandler = new JavetReflectionProxyV8ValueObjectInvocationHandler((V8ValueObject)v8Value.toClone());
            }
            if (invocationHandler != null) {
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type, AutoCloseable.class}, (InvocationHandler)invocationHandler);
            }
        }
        return null;
    }
}

