/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy.plugins;

import com.caoccao.javet.entities.JavetEntityPropertyDescriptor;
import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.exceptions.V8ErrorTemplate;
import com.caoccao.javet.interfaces.IJavetEntityPropertyDescriptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.plugins.BaseJavetProxyPluginSingle;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.ListUtils;
import com.caoccao.javet.utils.SimpleList;
import com.caoccao.javet.utils.SimpleSet;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class JavetProxyPluginArray
extends BaseJavetProxyPluginSingle<Object> {
    public static final String NAME = Object[].class.getName();
    protected static final String AT = "at";
    protected static final String CONCAT = "concat";
    protected static final String COPY_WITHIN = "copyWithin";
    protected static final String ENTRIES = "entries";
    protected static final String ERROR_TARGET_OBJECT_MUST_BE_AN_ARRAY = "Target object must be an array.";
    protected static final String EVERY = "every";
    protected static final String FILL = "fill";
    protected static final String FILTER = "filter";
    protected static final String FIND = "find";
    protected static final String FIND_INDEX = "findIndex";
    protected static final String FIND_LAST = "findLast";
    protected static final String FIND_LAST_INDEX = "findLastIndex";
    protected static final String FLAT = "flat";
    protected static final String FLAT_MAP = "flatMap";
    protected static final String FOR_EACH = "forEach";
    protected static final String INCLUDES = "includes";
    protected static final String INDEX_OF = "indexOf";
    protected static final String JOIN = "join";
    protected static final String KEYS = "keys";
    protected static final String LAST_INDEX_OF = "lastIndexOf";
    protected static final String LENGTH = "length";
    protected static final String[] DEFAULT_PROXYABLE_METHODS = new String[]{"length", "toString"};
    protected static final String MAP = "map";
    protected static final String POP = "pop";
    protected static final String PUSH = "push";
    protected static final String REDUCE = "reduce";
    protected static final String REDUCE_RIGHT = "reduceRight";
    protected static final String REVERSE = "reverse";
    protected static final String SHIFT = "shift";
    protected static final String SLICE = "slice";
    protected static final String SOME = "some";
    protected static final String SORT = "sort";
    protected static final String SPLICE = "splice";
    protected static final String TO_REVERSED = "toReversed";
    protected static final String TO_SORTED = "toSorted";
    protected static final String TO_SPLICED = "toSpliced";
    protected static final String UNSHIFT = "unshift";
    protected static final String VALUES = "values";
    protected static final String WITH = "with";
    private static final JavetProxyPluginArray instance = new JavetProxyPluginArray();
    protected final Set<String> proxyableMethods = SimpleSet.of(DEFAULT_PROXYABLE_METHODS);

    public JavetProxyPluginArray() {
        this.proxyGetByStringMap.put(AT, this::at);
        this.proxyGetByStringMap.put(CONCAT, this::concat);
        this.proxyGetByStringMap.put(COPY_WITHIN, this::copyWithin);
        this.proxyGetByStringMap.put(ENTRIES, this::entries);
        this.proxyGetByStringMap.put(EVERY, this::every);
        this.proxyGetByStringMap.put(FILL, this::fill);
        this.proxyGetByStringMap.put(FILTER, this::filter);
        this.proxyGetByStringMap.put(FIND, this::find);
        this.proxyGetByStringMap.put(FIND_INDEX, this::findIndex);
        this.proxyGetByStringMap.put(FIND_LAST, this::findLast);
        this.proxyGetByStringMap.put(FIND_LAST_INDEX, this::findLastIndex);
        this.proxyGetByStringMap.put(FLAT, this::flat);
        this.proxyGetByStringMap.put(FLAT_MAP, this::flatMap);
        this.proxyGetByStringMap.put(FOR_EACH, this::forEach);
        this.proxyGetByStringMap.put(INCLUDES, this::includes);
        this.proxyGetByStringMap.put(INDEX_OF, this::indexOf);
        this.proxyGetByStringMap.put(JOIN, this::join);
        this.proxyGetByStringMap.put(KEYS, this::keys);
        this.proxyGetByStringMap.put(LAST_INDEX_OF, this::lastIndexOf);
        this.proxyGetByStringMap.put(LENGTH, this::length);
        this.proxyGetByStringMap.put(MAP, this::map);
        this.proxyGetByStringMap.put(POP, this::pop);
        this.proxyGetByStringMap.put(PUSH, this::push);
        this.proxyGetByStringMap.put(REDUCE, this::reduce);
        this.proxyGetByStringMap.put(REDUCE_RIGHT, this::reduceRight);
        this.proxyGetByStringMap.put(REVERSE, this::reverse);
        this.proxyGetByStringMap.put(SHIFT, this::shift);
        this.proxyGetByStringMap.put(SLICE, this::slice);
        this.proxyGetByStringMap.put(SOME, this::some);
        this.proxyGetByStringMap.put(SORT, this::sort);
        this.proxyGetByStringMap.put(SPLICE, this::splice);
        this.proxyGetByStringMap.put("toJSON", this::toJSON);
        this.proxyGetByStringMap.put(TO_REVERSED, this::toReversed);
        this.proxyGetByStringMap.put(TO_SORTED, this::toSorted);
        this.proxyGetByStringMap.put(TO_SPLICED, this::toSpliced);
        this.proxyGetByStringMap.put("toString", this::toString);
        this.proxyGetByStringMap.put(UNSHIFT, this::unshift);
        this.proxyGetByStringMap.put("valueOf", this::valueOf);
        this.proxyGetByStringMap.put(VALUES, this::values);
        this.proxyGetByStringMap.put(WITH, this::with);
        this.proxyGetBySymbolMap.put("Symbol.iterator", this::values);
    }

    public static JavetProxyPluginArray getInstance() {
        return instance;
    }

    public V8Value at(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(AT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            int index = V8ValueUtils.asInt(v8Values, 0);
            if (index < 0) {
                index += length;
            }
            if (index >= 0 && index < length) {
                return v8Runtime.toV8Value(Array.get(targetObject, index));
            }
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value concat(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(CONCAT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            ArrayList<V8Value> results = new ArrayList<V8Value>();
            ListUtils.addAll(results, targetObject);
            if (ArrayUtils.isNotEmpty(v8Values)) {
                for (V8Value v8Value : v8Values) {
                    if (v8Value instanceof IV8ValueArray) {
                        IV8ValueArray iV8ValueArray = (IV8ValueArray)((Object)v8Value);
                        V8Value[] items = new V8Value[iV8ValueArray.getLength()];
                        if (!ArrayUtils.isNotEmpty(items)) continue;
                        iV8ValueArray.batchGet(items, 0, items.length);
                        Collections.addAll(results, items);
                        continue;
                    }
                    Object object = v8Runtime.toObject(v8Value);
                    if (object instanceof List) {
                        Collections.addAll(results, (List)object);
                        continue;
                    }
                    if (object != null && object.getClass().isArray()) {
                        ListUtils.addAll(results, object);
                        continue;
                    }
                    results.add(v8Value);
                }
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
        }));
    }

    public V8Value copyWithin(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(COPY_WITHIN, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            Object[] objects = ArrayUtils.copyOf(targetObject);
            int length = Array.getLength(targetObject);
            if (length > 0 && ArrayUtils.isNotEmpty(v8Values)) {
                int endIndex;
                int startIndex;
                int targetIndex = V8ValueUtils.asInt(v8Values, 0);
                if (targetIndex < 0 && (targetIndex += length) < 0) {
                    targetIndex = 0;
                }
                if ((startIndex = V8ValueUtils.asInt(v8Values, 1)) < 0 && (startIndex += length) < 0) {
                    startIndex = 0;
                }
                if ((endIndex = V8ValueUtils.asInt(v8Values, 2)) < 0 && (endIndex += length) < 0) {
                    endIndex = 0;
                }
                if (endIndex > length) {
                    endIndex = length;
                }
                if (endIndex == 0) {
                    endIndex = length;
                }
                if (targetIndex < length && startIndex < length && endIndex > startIndex) {
                    if (targetIndex + endIndex - startIndex > length) {
                        endIndex = length + startIndex - targetIndex;
                    }
                    for (int i = startIndex; i < endIndex; ++i) {
                        Array.set(targetObject, targetIndex + i - startIndex, objects[i]);
                    }
                }
            }
            return thisObject;
        }));
    }

    @Override
    protected V8Value createTargetObject(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return v8Runtime.createV8ValueArray();
    }

    @Override
    public boolean deleteByObject(Object targetObject, Object propertyKey) {
        int index;
        String propertyName;
        this.validateTargetObject(targetObject);
        if (propertyKey instanceof String && StringUtils.isDigital(propertyName = (String)propertyKey) && (index = Integer.parseInt(propertyName)) >= 0 && index < Array.getLength(targetObject) && !targetObject.getClass().getComponentType().isPrimitive()) {
            Array.set(targetObject, index, null);
            return true;
        }
        return false;
    }

    public V8Value entries(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(ENTRIES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            List entries = IntStream.range(0, length).mapToObj(i -> SimpleList.of(i, Array.get(targetObject, i))).collect(Collectors.toList());
            return PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(entries.iterator()));
        }));
    }

    public V8Value every(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(EVERY, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = 0; i < length; ++i) {
                    try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (result.asBoolean()) continue;
                        V8ValueBoolean v8ValueBoolean = v8Runtime.createV8ValueBoolean(false);
                        return v8ValueBoolean;
                    }
                }
                return v8Runtime.createV8ValueBoolean(true);
            }
            return v8Runtime.createV8ValueBoolean(false);
        }));
    }

    public V8Value fill(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FILL, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            int length = Array.getLength(targetObject);
            if (length > 0 && ArrayUtils.isNotEmpty(v8Values)) {
                int endIndex;
                V8Value v8Value = v8Values[0];
                int startIndex = V8ValueUtils.asInt(v8Values, 1);
                if (startIndex < 0 && (startIndex += length) < 0) {
                    startIndex = 0;
                }
                if ((endIndex = V8ValueUtils.asInt(v8Values, 2)) < 0 && (endIndex += length) < 0) {
                    endIndex = 0;
                }
                if (endIndex == 0) {
                    endIndex = length;
                }
                if (startIndex < length && endIndex > startIndex) {
                    for (int i = startIndex; i < endIndex; ++i) {
                        Array.set(targetObject, i, v8Runtime.toObject(v8Value));
                    }
                }
            }
            return thisObject;
        }));
    }

    public V8Value filter(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FILTER, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            int length = Array.getLength(targetObject);
            ArrayList<Object> results = new ArrayList<Object>(length);
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                for (int i = 0; i < length; ++i) {
                    Object object = Array.get(targetObject, i);
                    try (Object v8ValueResult = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (!v8ValueResult.asBoolean()) continue;
                        results.add(object);
                        continue;
                    }
                }
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
        }));
    }

    public V8Value find(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = 0; i < length; ++i) {
                    Object object = Array.get(targetObject, i);
                    try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (!result.asBoolean()) continue;
                        Object v = v8Runtime.toV8Value(object);
                        return v;
                    }
                }
            }
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value findIndex(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND_INDEX, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = 0; i < length; ++i) {
                    try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (!result.asBoolean()) continue;
                        V8ValueInteger v8ValueInteger = v8Runtime.createV8ValueInteger(i);
                        return v8ValueInteger;
                    }
                }
            }
            return v8Runtime.createV8ValueInteger(-1);
        }));
    }

    public V8Value findLast(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND_LAST, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = length - 1; i >= 0; --i) {
                    Object object = Array.get(targetObject, i);
                    try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, object, v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (!result.asBoolean()) continue;
                        Object v = v8Runtime.toV8Value(object);
                        return v;
                    }
                }
            }
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value findLastIndex(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FIND_LAST_INDEX, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = length - 1; i >= 0; --i) {
                    try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (!result.asBoolean()) continue;
                        V8ValueInteger v8ValueInteger = v8Runtime.createV8ValueInteger(i);
                        return v8ValueInteger;
                    }
                }
            }
            return v8Runtime.createV8ValueInteger(-1);
        }));
    }

    public V8Value flat(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FLAT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int depth = V8ValueUtils.asInt(v8Values, 0, 1);
            int length = Array.getLength(targetObject);
            ArrayList results = new ArrayList(length);
            ListUtils.flat(results, SimpleList.of(ArrayUtils.copyOf(targetObject)), depth);
            return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
        }));
    }

    public V8Value flatMap(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FLAT_MAP, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            int length = Array.getLength(targetObject);
            ArrayList results = new ArrayList(length);
            try {
                V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
                if (v8ValueFunction != null) {
                    V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                    for (int i = 0; i < length; ++i) {
                        results.add(v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject));
                    }
                }
                try (V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());){
                    V8ValueArray v8ValueArray2 = (V8ValueArray)v8ValueArray.flat();
                    return v8ValueArray2;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JavetResourceUtils.safeClose(results);
            }
        }));
    }

    public V8Value forEach(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FOR_EACH, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = 0; i < length; ++i) {
                    Object v8ValueResult = v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject);
                    Throwable throwable = null;
                    if (v8ValueResult == null) continue;
                    if (throwable != null) {
                        try {
                            ((V8Value)v8ValueResult).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ((V8Value)v8ValueResult).close();
                }
            }
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    @Override
    public Object getByIndex(Object targetObject, int index) {
        this.validateTargetObject(targetObject);
        if (index >= 0 && index < Array.getLength(targetObject)) {
            return Array.get(targetObject, index);
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object[] getProxyOwnKeys(Object targetObject) {
        this.validateTargetObject(targetObject);
        ArrayList<String> keys = new ArrayList<String>();
        IntStream.range(0, Array.getLength(targetObject)).boxed().forEach(keys::add);
        keys.add(LENGTH);
        return keys.toArray();
    }

    @Override
    public <T> IJavetEntityPropertyDescriptor<T> getProxyOwnPropertyDescriptor(Object targetObject, Object propertyName) {
        if (propertyName instanceof String) {
            if (LENGTH.equals(propertyName)) {
                return new JavetEntityPropertyDescriptor(false, false, true);
            }
            return new JavetEntityPropertyDescriptor(true, true, true);
        }
        return new JavetEntityPropertyDescriptor(false, false, false);
    }

    @Override
    public boolean hasByObject(Object targetObject, Object propertyKey) {
        String propertyName;
        this.validateTargetObject(targetObject);
        if (propertyKey instanceof String && StringUtils.isDigital(propertyName = (String)propertyKey)) {
            int index = Integer.parseInt(propertyName);
            return index >= 0 && index < Array.getLength(targetObject);
        }
        return false;
    }

    public V8Value includes(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(INCLUDES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            boolean included = false;
            if (ArrayUtils.isNotEmpty(v8Values)) {
                Object object = v8Runtime.toObject(v8Values[0]);
                int fromIndex = V8ValueUtils.asInt(v8Values, 1);
                int length = Array.getLength(targetObject);
                if (fromIndex < 0) {
                    fromIndex += length;
                }
                if (fromIndex < 0) {
                    fromIndex = 0;
                }
                if (fromIndex < length) {
                    included = ArrayUtils.includes(targetObject, object, fromIndex);
                }
            }
            return v8Runtime.createV8ValueBoolean(included);
        }));
    }

    public V8Value indexOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(INDEX_OF, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int index = -1;
            if (ArrayUtils.isNotEmpty(v8Values)) {
                Object object = v8Runtime.toObject(v8Values[0]);
                int fromIndex = V8ValueUtils.asInt(v8Values, 1);
                int length = Array.getLength(targetObject);
                if (fromIndex < 0) {
                    fromIndex += length;
                }
                if (fromIndex < 0) {
                    fromIndex = 0;
                }
                if (fromIndex < length) {
                    index = ArrayUtils.indexOf(targetObject, object, fromIndex);
                }
            }
            return v8Runtime.createV8ValueInteger(index);
        }));
    }

    @Override
    public boolean isDeleteSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isHasSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isIndexSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isMethodProxyable(String methodName, Class<?> targetClass) {
        return this.proxyableMethods.contains(methodName);
    }

    @Override
    public boolean isOwnKeysSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isProxyable(Class<?> targetClass) {
        return targetClass != null && targetClass.isArray();
    }

    public V8Value join(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(JOIN, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            String delimiter = V8ValueUtils.asString(v8Values, 0, "");
            String result = Stream.of(ArrayUtils.copyOf(targetObject)).map(Object::toString).collect(Collectors.joining(delimiter));
            return v8Runtime.createV8ValueString(result);
        }));
    }

    public V8Value keys(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(KEYS, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            Object[] indexes = new Object[length];
            for (int i = 0; i < length; ++i) {
                indexes[i] = v8Runtime.createV8ValueInteger(i);
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, indexes);
        }));
    }

    public V8Value lastIndexOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(LAST_INDEX_OF, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int index = -1;
            if (ArrayUtils.isNotEmpty(v8Values)) {
                Object object = v8Runtime.toObject(v8Values[0]);
                int length = Array.getLength(targetObject);
                int fromIndex = V8ValueUtils.asInt(v8Values, 1, length - 1);
                if (fromIndex < 0) {
                    fromIndex += length;
                }
                if (fromIndex < 0) {
                    fromIndex = length - 1;
                }
                if (fromIndex <= length) {
                    index = ArrayUtils.lastIndexOf(targetObject, object, fromIndex);
                }
            }
            return v8Runtime.createV8ValueInteger(index);
        }));
    }

    public V8Value length(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueInteger(Array.getLength(targetObject));
    }

    public V8Value map(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(MAP, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            int length = Array.getLength(targetObject);
            ArrayList results = new ArrayList(length);
            try {
                V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
                if (v8ValueFunction != null) {
                    V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                    for (int i = 0; i < length; ++i) {
                        results.add(v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject));
                    }
                }
                V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
                return v8ValueArray;
            }
            finally {
                JavetResourceUtils.safeClose(results);
            }
        }));
    }

    public V8Value pop(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(POP, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorFunctionIsNotSupported(POP));
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value push(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(PUSH, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorFunctionIsNotSupported(PUSH));
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value reduce(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(REDUCE, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            void var7_11;
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction == null) return v8Runtime.createV8ValueUndefined();
            V8Value initialValue = V8ValueUtils.asV8Value(v8Values, 1);
            int length = Array.getLength(targetObject);
            if (initialValue == null) {
                void var7_8;
                if (length == 0) {
                    v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorReduceOfEmptyArrayWithNoInitialValue());
                    return v8Runtime.createV8ValueUndefined();
                }
                if (length == 1) {
                    return v8Runtime.toV8Value(Array.get(targetObject, 0));
                }
                Object v = v8Runtime.toV8Value(Array.get(targetObject, 0));
                for (int i = 1; i < length; ++i) {
                    Object result;
                    try (Object currentValue = v8Runtime.toV8Value(Array.get(targetObject, i));){
                        result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_8, currentValue, v8Runtime.createV8ValueInteger(i), thisObject});
                    }
                    finally {
                        JavetResourceUtils.safeClose((Object)var7_8);
                    }
                    Object t = result;
                }
                return var7_8;
            }
            if (length == 0) {
                return initialValue;
            }
            Object t = initialValue.toClone();
            for (int i = 0; i < length; ++i) {
                Object result;
                try (Object currentValue = v8Runtime.toV8Value(Array.get(targetObject, i));){
                    result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_11, currentValue, v8Runtime.createV8ValueInteger(i), thisObject});
                }
                finally {
                    JavetResourceUtils.safeClose((Object)var7_11);
                }
                Object t2 = result;
            }
            return var7_11;
        }));
    }

    public V8Value reduceRight(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(REDUCE, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            void var7_11;
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction == null) return v8Runtime.createV8ValueUndefined();
            V8Value initialValue = V8ValueUtils.asV8Value(v8Values, 1);
            int length = Array.getLength(targetObject);
            if (initialValue == null) {
                void var7_8;
                if (length == 0) {
                    v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorReduceOfEmptyArrayWithNoInitialValue());
                    return v8Runtime.createV8ValueUndefined();
                }
                if (length == 1) {
                    return v8Runtime.toV8Value(Array.get(targetObject, 0));
                }
                Object v = v8Runtime.toV8Value(Array.get(targetObject, length - 1));
                for (int i = length - 2; i >= 0; --i) {
                    Object result;
                    try (Object currentValue = v8Runtime.toV8Value(Array.get(targetObject, i));){
                        result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_8, currentValue, v8Runtime.createV8ValueInteger(i), thisObject});
                    }
                    finally {
                        JavetResourceUtils.safeClose((Object)var7_8);
                    }
                    Object t = result;
                }
                return var7_8;
            }
            if (length == 0) {
                return initialValue;
            }
            Object t = initialValue.toClone();
            for (int i = length - 1; i >= 0; --i) {
                Object result;
                try (Object currentValue = v8Runtime.toV8Value(Array.get(targetObject, i));){
                    result = v8ValueFunction.call((V8Value)null, new V8Value[]{var7_11, currentValue, v8Runtime.createV8ValueInteger(i), thisObject});
                }
                finally {
                    JavetResourceUtils.safeClose((Object)var7_11);
                }
                Object t2 = result;
            }
            return var7_11;
        }));
    }

    public V8Value reverse(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(REVERSE, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            ArrayUtils.reverse(targetObject);
            return thisObject;
        }));
    }

    @Override
    public boolean setByIndex(Object targetObject, int index, Object value) {
        this.validateTargetObject(targetObject);
        if (index >= 0 && index < Array.getLength(targetObject)) {
            Array.set(targetObject, index, value);
            return true;
        }
        return false;
    }

    public V8Value shift(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SHIFT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorFunctionIsNotSupported(SHIFT));
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value slice(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SLICE, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            ArrayList<Object> results = new ArrayList<Object>();
            if (length > 0) {
                int endIndex;
                int startIndex = V8ValueUtils.asInt(v8Values, 0);
                if (startIndex < 0) {
                    startIndex += length;
                }
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if ((endIndex = V8ValueUtils.asInt(v8Values, 1, length)) < 0) {
                    endIndex += length;
                }
                if (endIndex < 0) {
                    endIndex = 0;
                }
                if (endIndex > length) {
                    endIndex = length;
                }
                for (int i = startIndex; i < endIndex; ++i) {
                    results.add(Array.get(targetObject, i));
                }
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
        }));
    }

    public V8Value some(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SOME, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
            if (v8ValueFunction != null) {
                V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
                int length = Array.getLength(targetObject);
                for (int i = 0; i < length; ++i) {
                    try (Object result = v8ValueFunction.call((V8Value)v8ValueObject, Array.get(targetObject, i), v8Runtime.createV8ValueInteger(i), thisObject);){
                        if (!result.asBoolean()) continue;
                        V8ValueBoolean v8ValueBoolean = v8Runtime.createV8ValueBoolean(true);
                        return v8ValueBoolean;
                    }
                }
            }
            return v8Runtime.createV8ValueBoolean(false);
        }));
    }

    public V8Value sort(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SORT, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            int length = Array.getLength(targetObject);
            if (length > 1) {
                V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunction(v8Values, 0);
                ArrayList list = new ArrayList(length);
                ListUtils.addAll(list, targetObject);
                if (v8ValueFunction == null) {
                    list.sort((o1, o2) -> Comparator.naturalOrder().compare(String.valueOf(o1), String.valueOf(o2)));
                } else {
                    try {
                        list.sort((o1, o2) -> {
                            try (Object v8Value = v8ValueFunction.call(null, o1, o2);){
                                int n = v8Value.asInt();
                                return n;
                            }
                            catch (JavetException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (Throwable t) {
                        v8Runtime.throwError(V8ValueErrorType.Error, t.getMessage());
                    }
                }
                int index = 0;
                for (Object object : list) {
                    Array.set(targetObject, index, object);
                    ++index;
                }
            }
            return thisObject;
        }));
    }

    public V8Value splice(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(SPLICE, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorFunctionIsNotSupported(SPLICE));
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    public V8Value toJSON(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toJSON", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> V8ValueUtils.createV8ValueArray(v8Runtime, ArrayUtils.copyOf(targetObject))));
    }

    public V8Value toReversed(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(TO_REVERSED, targetObject, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> {
            int length = Array.getLength(targetObject);
            ArrayList reversedList = new ArrayList(length);
            ListUtils.addAll(reversedList, targetObject);
            Collections.reverse(reversedList);
            return V8ValueUtils.createV8ValueArray(v8Runtime, reversedList.toArray());
        }));
    }

    public V8Value toSorted(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(TO_SORTED, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            ArrayList results = new ArrayList(length);
            ListUtils.addAll(results, targetObject);
            if (length > 1) {
                V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunction(v8Values, 0);
                if (v8ValueFunction == null) {
                    results.sort((o1, o2) -> Comparator.naturalOrder().compare(String.valueOf(o1), String.valueOf(o2)));
                } else {
                    try {
                        results.sort((o1, o2) -> {
                            try (Object v8Value = v8ValueFunction.call(null, o1, o2);){
                                int n = v8Value.asInt();
                                return n;
                            }
                            catch (JavetException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (Throwable t) {
                        v8Runtime.throwError(V8ValueErrorType.Error, t.getMessage());
                    }
                }
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
        }));
    }

    public V8Value toSpliced(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(TO_SPLICED, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            ArrayList results = new ArrayList(length);
            ListUtils.addAll(results, targetObject);
            if (ArrayUtils.isNotEmpty(v8Values)) {
                int startIndex = V8ValueUtils.asInt(v8Values, 0);
                if (startIndex < 0) {
                    startIndex += length;
                }
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (startIndex >= length) {
                    v8Runtime.throwError(V8ValueErrorType.RangeError, V8ErrorTemplate.rangeErrorStartIsOutOfRange(startIndex));
                } else {
                    int deleteCount = V8ValueUtils.asInt(v8Values, 1);
                    if ((deleteCount = Math.min(deleteCount, length - startIndex)) > 0) {
                        results.subList(startIndex, startIndex + deleteCount).clear();
                    }
                    if (v8Values.length > 2) {
                        ArrayList toBeAddedList = new ArrayList();
                        for (int i = 2; i < v8Values.length; ++i) {
                            toBeAddedList.add(v8Runtime.toObject(v8Values[i]));
                        }
                        results.addAll(startIndex, toBeAddedList);
                    }
                }
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, results.toArray());
        }));
    }

    public V8Value toString(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toString", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            try (V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(v8Runtime, ArrayUtils.copyOf(targetObject));){
                V8ValueString v8ValueString = v8Runtime.createV8ValueString(v8ValueArray.toString());
                return v8ValueString;
            }
        }));
    }

    public V8Value unshift(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(UNSHIFT, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            v8Runtime.throwError(V8ValueErrorType.TypeError, V8ErrorTemplate.typeErrorFunctionIsNotSupported(UNSHIFT));
            return v8Runtime.createV8ValueUndefined();
        }));
    }

    @Override
    protected Object validateTargetObject(Object targetObject) {
        assert (targetObject != null && targetObject.getClass().isArray()) : "Target object must be an array.";
        return targetObject;
    }

    public V8Value valueOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("valueOf", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> V8ValueUtils.createV8ValueArray(v8Runtime, ArrayUtils.copyOf(targetObject))));
    }

    public V8Value values(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(VALUES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            int length = Array.getLength(targetObject);
            ArrayList values = new ArrayList(length);
            ListUtils.addAll(values, targetObject);
            return PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(values.iterator()));
        }));
    }

    public V8Value with(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(WITH, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
            Object[] objects = ArrayUtils.copyOf(targetObject);
            int index = V8ValueUtils.asInt(v8Values, 0);
            if (index >= 0 && index < objects.length) {
                objects[index] = v8Values.length > 1 ? v8Values[1] : v8Runtime.createV8ValueUndefined();
            } else {
                v8Runtime.throwError(V8ValueErrorType.RangeError, V8ErrorTemplate.rangeErrorInvalidIndex(index));
            }
            return V8ValueUtils.createV8ValueArray(v8Runtime, objects);
        }));
    }
}

