/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.primitive;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.IV8ValuePrimitiveValue;
import com.caoccao.javet.values.primitive.V8ValueNumber;
import com.caoccao.javet.values.reference.V8ValueDoubleObject;

public final class V8ValueDouble
extends V8ValueNumber<Double>
implements IV8ValuePrimitiveValue<V8ValueDoubleObject> {
    public static final String INFINITY = "Infinity";

    public V8ValueDouble(V8Runtime v8Runtime) throws JavetException {
        this(v8Runtime, 0.0);
    }

    public V8ValueDouble(V8Runtime v8Runtime, double value) throws JavetException {
        super(v8Runtime, value);
    }

    @Override
    public boolean asBoolean() {
        return (Double)this.value != 0.0 && !Double.isNaN((Double)this.value) && Double.isFinite((Double)this.value);
    }

    @Override
    public double asDouble() throws JavetException {
        return (Double)this.value;
    }

    @Override
    public int asInt() {
        return ((Double)this.value).intValue();
    }

    @Override
    public long asLong() throws JavetException {
        return ((Double)this.value).longValue();
    }

    public boolean isFinite() {
        return Double.isFinite((Double)this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite((Double)this.value);
    }

    public boolean isNaN() {
        return Double.isNaN((Double)this.value);
    }

    public V8ValueDouble toClone(boolean referenceCopy) throws JavetException {
        return this;
    }

    @Override
    public V8ValueDoubleObject toObject() throws JavetException {
        return this.checkV8Runtime().createV8ValueDoubleObject((Double)this.value);
    }

    public double toPrimitive() {
        return (Double)this.value;
    }

    @Override
    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        try {
            return this.checkV8Runtime().getExecutor("(" + this.value + ").toString(" + radix + ")").executeString();
        }
        catch (JavetException e) {
            return ((Double)this.value).toString();
        }
    }
}

