/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.primitive;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.values.IV8ValuePrimitiveValue;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.reference.V8ValueStringObject;
import java.util.Objects;

public final class V8ValueString
extends V8ValuePrimitive<String>
implements IV8ValuePrimitiveValue<V8ValueStringObject> {
    public V8ValueString(V8Runtime v8Runtime) throws JavetException {
        this(v8Runtime, null);
    }

    public V8ValueString(V8Runtime v8Runtime, String value) throws JavetException {
        super(v8Runtime, Objects.requireNonNull(value));
    }

    @Override
    public boolean asBoolean() {
        return StringUtils.isNotEmpty((String)this.value);
    }

    @Override
    public double asDouble() {
        String trimmedString = ((String)this.value).trim();
        try {
            return Double.parseDouble(trimmedString);
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    @Override
    public int asInt() {
        String trimmedString = ((String)this.value).trim();
        if (StringUtils.isDigital(trimmedString)) {
            try {
                return Integer.parseInt(trimmedString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public long asLong() {
        String trimmedString = ((String)this.value).trim();
        if (StringUtils.isDigital(trimmedString)) {
            try {
                return Long.parseLong(trimmedString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0L;
    }

    public V8ValueString toClone(boolean referenceCopy) throws JavetException {
        return this;
    }

    @Override
    public V8ValueStringObject toObject() throws JavetException {
        return this.checkV8Runtime().createV8ValueStringObject((String)this.value);
    }

    public String toPrimitive() {
        return (String)this.value;
    }

    @Override
    public String toString() {
        return (String)this.value;
    }
}

